/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcExtensions {

    public static class FilePresentation
    implements FileIconProvider,
    EditorTabTitleProvider {
        @Nullable
        public Icon getIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project) {
            if (file == null) {
                FilePresentation.$$$reportNull$$$0(0);
            }
            return DbSrcUtils.isDbSrcFile(file) ? DbSrcUtils.getIcon(project, file.getPath()) : null;
        }

        @Nullable
        public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                FilePresentation.$$$reportNull$$$0(1);
            }
            if (file == null) {
                FilePresentation.$$$reportNull$$$0(2);
            }
            if (!DbSrcUtils.isDbSrcFile(file)) {
                return null;
            }
            ObjectPath path = DbSrcUtils.getFullPath(file.getPath());
            if (path == null) {
                return null;
            }
            String dataSourceId = DbSrcUtils.getDataSource(file);
            DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
            return DatabaseElementVirtualFileImpl.getEditorTabTitleImpl(project, file, path, dataSource);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/srcStorage/DbSrcExtensions$FilePresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getIcon";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEditorTabTitle";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UsageTypeExtension
    implements UsageTypeProvider {
        private static final ConcurrentMap<ObjectKind, UsageType> ourUsageTypes = ConcurrentFactoryMap.createMap(key2 -> new UsageType("Usage in " + StringUtil.capitalize((String)StringUtil.pluralize((String)key2.code()))));

        @Nullable
        public UsageType getUsageType(PsiElement element2) {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element2);
            ObjectKind kind = DbSrcUtils.isDbSrcFile(file) ? DbSrcUtils.getKind(file.getPath()) : null;
            return kind == null ? null : (UsageType)ourUsageTypes.get(kind);
        }
    }
}

