/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.perforce.application.AbstractUpdateEnvironment;
import org.jetbrains.idea.perforce.application.PerforceCheckinHandlerFactory;
import org.jetbrains.idea.perforce.application.PerforceIsOfflinePanel;
import org.jetbrains.idea.perforce.application.PerforcePanel;
import org.jetbrains.idea.perforce.application.PerforceUpdateConfigurable;
import org.jetbrains.idea.perforce.application.PerforceUpdatePanel;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;

public class PerforceUpdateEnvironment
extends AbstractUpdateEnvironment {
    @NonNls
    private static final String DELETED_MESSAGE = " - deleted as ";
    @NonNls
    private static final String UPDATING_MESSAGE = " - updating ";
    @NonNls
    private static final String ADDED_MESSAGE = " - added as ";
    @NonNls
    private static final String MERGE_MESSAGE = " - is opened and not being changed";
    private static final Map<String, String> ourPatternToGroupId = new HashMap<String, String>();

    public PerforceUpdateEnvironment(Project project) {
        super(project);
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
    }

    @Override
    protected boolean isTryToResolveAutomatically(PerforceSettings settings) {
        return settings.SYNC_RUN_RESOLVE;
    }

    @Override
    protected Map<String, String> getPatternToGroupId() {
        return ourPatternToGroupId;
    }

    @Override
    protected boolean isRevertUnchanged(PerforceSettings settings) {
        return settings.REVERT_UNCHANGED_FILES;
    }

    @Override
    protected ExecResult performUpdate(P4File p4Dir, PerforceSettings settings) throws VcsException {
        return this.myRunner.sync(p4Dir, settings.SYNC_FORCE);
    }

    public Configurable createConfigurable(Collection<FilePath> files) {
        return new PerforceUpdateConfigurable(this.getSettings()){

            @Override
            protected PerforcePanel createPanel() {
                return PerforceSettings.getSettings((Project)PerforceUpdateEnvironment.this.myProject).ENABLED ? new PerforceUpdatePanel() : new PerforceIsOfflinePanel();
            }

            @Override
            public String getHelpTopic() {
                return "reference.vcs.update.project.perforce";
            }
        };
    }

    public boolean validateOptions(Collection<FilePath> roots) {
        return PerforceCheckinHandlerFactory.beforeRemoteOperationCheck(this.myProject, "Update");
    }

    static {
        ourPatternToGroupId.put(DELETED_MESSAGE, "REMOVED_FROM_REPOSITORY");
        ourPatternToGroupId.put(UPDATING_MESSAGE, "UPDATED");
        ourPatternToGroupId.put(ADDED_MESSAGE, "CREATED");
        ourPatternToGroupId.put(MERGE_MESSAGE, "MERGED");
    }
}

