/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline.function;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.refactoring.PhpRefactoringErrorException;
import com.jetbrains.php.refactoring.inline.PhpInlineActionHandler;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionDialog;
import com.jetbrains.php.refactoring.inline.function.PhpInlineFunctionPresenter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInlineFunctionHandler
extends PhpInlineActionHandler {
    public static final String REFACTORING_NAME = "Inline variable";
    public static final String REFACTORING_HELP_ID = null;

    public boolean canInlineElement(PsiElement element) {
        return element instanceof Function;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor);
        FunctionReference functionReference = null;
        if (psiReference instanceof FunctionReference) {
            functionReference = (FunctionReference)psiReference;
        }
        try {
            PhpInlineFunctionHandler.invoke(project, editor, functionReference, (Function)element);
        }
        catch (PhpRefactoringErrorException e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)e.getMessage()), (String)REFACTORING_NAME, (String)REFACTORING_HELP_ID);
        }
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor, @Nullable FunctionReference functionReference, Function function) throws PhpRefactoringErrorException {
        if (project == null) {
            PhpInlineFunctionHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpInlineFunctionHandler.$$$reportNull$$$0(1);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        PhpInlineFunctionHandler.validate(project, functionReference, function);
        PhpInlineFunctionDialog dialog = new PhpInlineFunctionDialog(project, editor, function, functionReference);
        dialog.show();
    }

    public static void validate(@NotNull Project project, @Nullable FunctionReference functionReference, Function function) throws PhpRefactoringErrorException {
        VirtualFile virtualFile;
        Collection phpNamedElements;
        if (project == null) {
            PhpInlineFunctionHandler.$$$reportNull$$$0(2);
        }
        if (functionReference != null && (phpNamedElements = functionReference.resolveGlobal(false)).size() > 1) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.function.reference.is.ambiguous", new Object[0]));
        }
        if (function instanceof Method && !((Method)function).isStatic()) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.function.only.static.method.is.supported", new Object[0]));
        }
        GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (groupStatement == null) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.function.cannot.parse.function.body", new Object[0]));
        }
        PsiFile containingFile = function.getContainingFile();
        if (containingFile != null && (virtualFile = containingFile.getVirtualFile()) != null && !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile)) {
            throw new PhpRefactoringErrorException(PhpBundle.message("refactoring.inline.function.cannot.inline.library.function", new Object[0]));
        }
        Set<String> problems = PhpInlineFunctionHandler.validateBody(function);
        if (!problems.isEmpty()) {
            throw new PhpRefactoringErrorException(problems.iterator().next());
        }
    }

    public static MultiMap<PsiElement, String> validateFunctionContext(Function function, final FunctionReference functionReference) {
        final PhpClass contextClass = PhpInlineFunctionHandler.getContextClass(functionReference);
        final MultiMap problems = new MultiMap();
        function.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpMethodReference(MethodReference methodReference) {
                this.validateVisibilityOfMemberReference((MemberReference)methodReference);
                super.visitPhpMethodReference(methodReference);
            }

            public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
                this.validateVisibilityOfMemberReference((MemberReference)constantReference);
                super.visitPhpClassConstantReference(constantReference);
            }

            public void validateVisibilityOfMemberReference(MemberReference memberReference) {
                PsiElement resolve = memberReference.resolve();
                if (resolve != null) {
                    PhpClassMember classMember = (PhpClassMember)resolve;
                    PhpModifier modifier = classMember.getModifier();
                    PhpClass declarationClass = classMember.getContainingClass();
                    if (!(modifier.isPublic() || contextClass != null && declarationClass != null)) {
                        problems.putValue((Object)functionReference, (Object)PhpBundle.message("refactoring.inline.function.not.accessible.from.caller.site", memberReference.getText()));
                        return;
                    }
                    if (modifier.isPrivate() && contextClass != declarationClass) {
                        problems.putValue((Object)functionReference, (Object)PhpBundle.message("refactoring.inline.function.not.accessible.from.caller.site", memberReference.getText()));
                    }
                    if (modifier.isProtected() && !this.checkHierarchy(declarationClass)) {
                        problems.putValue((Object)functionReference, (Object)PhpBundle.message("refactoring.inline.function.not.accessible.from.caller.site", memberReference.getText()));
                    }
                }
            }

            public boolean checkHierarchy(PhpClass declarationClass) {
                return declarationClass != null && contextClass != null && contextClass != declarationClass && PhpClassHierarchyUtils.isSuperClass((PhpClass)declarationClass, (PhpClass)contextClass, (boolean)true);
            }
        });
        return problems;
    }

    @Nullable
    private static PhpClass getContextClass(FunctionReference functionReference) {
        Method method = (Method)PhpPsiUtil.getParentByCondition((PsiElement)functionReference, (Condition<? super PsiElement>)Method.INSTANCEOF);
        PhpClass contextClass = null;
        if (method != null) {
            contextClass = method.getContainingClass();
        }
        return contextClass;
    }

    private static Set<String> validateBody(final Function function) {
        final HashSet<String> problems = new HashSet<String>();
        final ArrayList<PhpReturn> returnStatements = new ArrayList<PhpReturn>();
        function.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpFunction(Function function2) {
                if (function2.isClosure()) {
                    return;
                }
                super.visitPhpFunction(function2);
            }

            public void visitPhpReturn(PhpReturn returnStatement) {
                returnStatements.add(returnStatement);
                super.visitPhpReturn(returnStatement);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.isRecursive(reference);
                super.visitPhpFunctionCall(reference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.isRecursive((FunctionReference)reference);
                super.visitPhpMethodReference(reference);
            }

            public void visitPhpClassReference(ClassReference classReference) {
                if ("parent".equals(classReference.getName()) && classReference.resolve() == null) {
                    problems.add(PhpBundle.message("refactoring.inline.function.parent.reference.unresolved", PhpInlineFunctionPresenter.getElementDescription(function, false)));
                }
                super.visitPhpClassReference(classReference);
            }

            public void visitPhpGlobal(Global globalStatement) {
                problems.add(PhpBundle.message("refactoring.inline.function.cannot.inline.function.with.global.usage", PhpInlineFunctionPresenter.getElementDescription(function, false)));
                super.visitPhpGlobal(globalStatement);
            }

            public void visitPhpYield(PhpYield element) {
                problems.add(PhpBundle.message("refactoring.inline.function.yield.found.in.function.body", new Object[0]));
                super.visitPhpYield(element);
            }

            private void isRecursive(FunctionReference reference) {
                if (reference.resolve() == function) {
                    problems.add(PhpBundle.message("refactoring.inline.function.reference.is.recursive", new Object[0]));
                }
            }
        });
        if (!returnStatements.isEmpty() && PhpInlineFunctionHandler.analyzeFunctionFlow(function, returnStatements)) {
            problems.add(PhpBundle.message("refactoring.inline.function.inline.function.refactoring.is.not.supported.when.return.statement.interrupts.the.execution.flow", new Object[0]));
        }
        return problems;
    }

    private static boolean analyzeFunctionFlow(Function function, Collection<PhpReturn> returns) {
        Function functionToProcess = PhpPsiElementFactory.createFunction(function.getProject(), function.getText());
        final LinkedHashSet statements = new LinkedHashSet();
        functionToProcess.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

            public void visitPhpReturn(PhpReturn returnStatement) {
                statements.add(returnStatement.replace((PsiElement)PhpPsiElementFactory.createStatement(returnStatement.getProject(), "$result = " + returnStatement.getArgument() + ";")));
            }
        });
        PhpControlFlow flow = functionToProcess.getControlFlow();
        final Ref result = new Ref();
        result.set((Object)false);
        for (PsiElement it : statements) {
            PhpStatementInstruction instruction = PhpControlFlowUtil.getStatementInstruction(flow, (Statement)it);
            if (instruction == null) continue;
            PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                    if (statements.contains(instruction.getStatement())) {
                        result.set((Object)true);
                        return false;
                    }
                    return true;
                }
            });
        }
        return (Boolean)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/inline/function/PhpInlineFunctionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

