/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.CommonProcessors;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeSignatureUsageSearcher {
    private static final Condition<PsiElement> ARRAY_VALUE = element -> PhpPsiUtil.isOfType(element, PhpElementTypes.ARRAY_VALUE);
    private final PhpChangeInfo myChangeInfo;

    public PhpChangeSignatureUsageSearcher(PhpChangeInfo changeInfo) {
        this.myChangeInfo = changeInfo;
    }

    @NotNull
    public UsageInfo[] findUsages() {
        Function method = this.myChangeInfo.getMethod();
        if (method == null) {
            if (UsageInfo.EMPTY_ARRAY == null) {
                PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(0);
            }
            return UsageInfo.EMPTY_ARRAY;
        }
        List<UsageInfo> result = this.findUsages(method, false);
        Set<Function> propagation = this.myChangeInfo.getFunctionsToPropagation();
        for (Function function : propagation) {
            if (!this.myChangeInfo.isConstructor() && PhpChangeSignatureUsageSearcher.isReferenceFromGoalMethod(function, method)) continue;
            result.addAll(this.findUsages(function, true));
        }
        UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(1);
        }
        return usageInfoArray;
    }

    @NotNull
    private List<UsageInfo> findUsages(@NotNull Function function, final boolean isPropagationUsage) {
        if (function == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(2);
        }
        final ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        CommonProcessors.FindProcessor<PsiReference> finder = new CommonProcessors.FindProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                PsiElement parent;
                if (reference instanceof FunctionReference) {
                    usages.add(PhpChangeSignatureUsageSearcher.constructCallUsageInfo((ParameterListOwner)((FunctionReference)reference), PhpChangeSignatureUsageSearcher.this.myChangeInfo, isPropagationUsage));
                } else if (reference instanceof ClassReference) {
                    PsiElement parent2 = ((ClassReference)reference).getParent();
                    if (parent2 instanceof NewExpression) {
                        usages.add(PhpChangeSignatureUsageSearcher.constructCallUsageInfo((ParameterListOwner)((NewExpression)parent2), PhpChangeSignatureUsageSearcher.this.myChangeInfo, isPropagationUsage));
                    }
                } else if (reference instanceof Variable && (parent = ((Variable)reference).getParent()) instanceof FunctionReference) {
                    usages.add(PhpChangeSignatureUsageSearcher.constructCallUsageInfo((ParameterListOwner)((FunctionReference)parent), PhpChangeSignatureUsageSearcher.this.myChangeInfo, isPropagationUsage));
                }
                return false;
            }
        };
        Collection<Function> allFunctions = PhpChangeSignatureUsageSearcher.processAllUsages(function, this.myChangeInfo.isConstructor(), (CommonProcessors.FindProcessor<? super PsiReference>)finder);
        for (Function curFunction : allFunctions) {
            usages.add(this.constructDeclarationUsageInfo(curFunction, isPropagationUsage));
        }
        ArrayList<UsageInfo> arrayList = usages;
        if (arrayList == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private PhpChangeSignatureUsageProcessor.PhpChangeSignatureUsageInfo constructDeclarationUsageInfo(@NotNull Function function, boolean isPropagationUsage) {
        PhpClass clazz;
        if (function == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(4);
        }
        if (isPropagationUsage) {
            PhpChangeSignatureUsageProcessor.FunctionPropagationDeclarationUsageInfo functionPropagationDeclarationUsageInfo = new PhpChangeSignatureUsageProcessor.FunctionPropagationDeclarationUsageInfo(function);
            if (functionPropagationDeclarationUsageInfo == null) {
                PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(5);
            }
            return functionPropagationDeclarationUsageInfo;
        }
        if (function instanceof Method && (clazz = ((Method)function).getContainingClass()) != null && clazz.isAbstract()) {
            PhpChangeSignatureUsageProcessor.FunctionDeclarationUsageInfo functionDeclarationUsageInfo = new PhpChangeSignatureUsageProcessor.FunctionDeclarationUsageInfo(function);
            if (functionDeclarationUsageInfo == null) {
                PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(6);
            }
            return functionDeclarationUsageInfo;
        }
        PhpChangeSignatureUsageProcessor.FunctionBodyUsageInfo functionBodyUsageInfo = new PhpChangeSignatureUsageProcessor.FunctionBodyUsageInfo(function, this.myChangeInfo);
        if (functionBodyUsageInfo == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(7);
        }
        return functionBodyUsageInfo;
    }

    @NotNull
    public static PhpChangeSignatureUsageProcessor.PhpChangeSignatureUsageInfo constructCallUsageInfo(@NotNull ParameterListOwner parameterOwner, @NotNull PhpChangeInfo changeInfo, boolean isPropagationUsage) {
        if (parameterOwner == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(8);
        }
        if (changeInfo == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(9);
        }
        if (isPropagationUsage) {
            PhpChangeSignatureUsageProcessor.FunctionPropagationCallUsageInfo functionPropagationCallUsageInfo = new PhpChangeSignatureUsageProcessor.FunctionPropagationCallUsageInfo(parameterOwner, changeInfo);
            if (functionPropagationCallUsageInfo == null) {
                PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(10);
            }
            return functionPropagationCallUsageInfo;
        }
        PhpChangeSignatureUsageProcessor.FunctionCallUsageInfo functionCallUsageInfo = new PhpChangeSignatureUsageProcessor.FunctionCallUsageInfo(parameterOwner, changeInfo);
        if (functionCallUsageInfo == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(11);
        }
        return functionCallUsageInfo;
    }

    @NotNull
    public static Collection<Function> processAllUsages(@NotNull Function rootFunction, boolean isConstructor, final @NotNull CommonProcessors.FindProcessor<? super PsiReference> finder) {
        if (rootFunction == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(12);
        }
        if (finder == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmpty((String)rootFunction.getName())) {
            final PhpPsiElement variable = PhpChangeSignatureUsageSearcher.getVariableFromAssignment((PsiElement)rootFunction);
            if (variable instanceof Variable) {
                PhpAccessVariableInstruction assignmentInstruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
                assert (assignmentInstruction != null);
                PhpControlFlowUtil.processSuccessors((PhpInstruction)assignmentInstruction, false, new PhpInstructionProcessor(){

                    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                        if (PhpLangUtil.equalsVariableNames(((Variable)variable).getNameCS(), instruction.getVariableName())) {
                            if (instruction.getAccess().isWrite()) {
                                return false;
                            }
                            finder.process((Object)((PsiReference)instruction.getAnchor()));
                        }
                        return true;
                    }
                });
            }
            Set<Function> set = Collections.singleton(rootFunction);
            if (set == null) {
                PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(14);
            }
            return set;
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)rootFunction.getProject());
        Collection<Function> overridingFunctions = PhpChangeSignatureUsageSearcher.getOverridingMembers(rootFunction, isConstructor);
        for (Function function : overridingFunctions) {
            ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)function, (SearchScope)scope, false);
            ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).forEach(finder);
        }
        Collection<Function> collection = overridingFunctions;
        if (collection == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @Nullable
    public static PhpPsiElement getVariableFromAssignment(@NotNull PsiElement element) {
        List values;
        int index;
        PsiElement arrayCreation;
        Object value;
        AssignmentExpression assignment;
        if (element == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(16);
        }
        if ((assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF)) instanceof MultiassignmentExpression && (value = PhpPsiUtil.getParentByCondition(element, ARRAY_VALUE)) != null && (arrayCreation = value.getParent()) instanceof ArrayCreationExpression && (index = (values = PhpPsiUtil.getChildren(arrayCreation, ARRAY_VALUE)).indexOf(value)) != -1) {
            List variables = ((MultiassignmentExpression)assignment).getVariables();
            return variables.size() == values.size() ? (PhpPsiElement)variables.get(index) : null;
        }
        return assignment == null ? null : assignment.getVariable();
    }

    @Nullable
    public static Method findDeepestSuperMethod(@NotNull Method method, boolean isConstructor) {
        if (method == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(17);
        }
        if (isConstructor) {
            return null;
        }
        Ref refBaseClass = new Ref();
        Ref refInterface = new Ref();
        PhpClassHierarchyUtils.HierarchyClassMemberProcessor collect = (classMember, subClass, baseClass) -> {
            if (classMember instanceof Method) {
                boolean isInterface = baseClass.isInterface();
                if (isInterface && !isConstructor) {
                    refInterface.set((Object)((Method)classMember));
                }
                if (!isInterface) {
                    refBaseClass.set((Object)((Method)classMember));
                }
                return true;
            }
            return false;
        };
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)method, (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)collect);
        if (!refBaseClass.isNull() && !isConstructor) {
            return PhpChangeSignatureUsageSearcher.getDeepestInterfaceMethod((Method)refBaseClass.get());
        }
        return refBaseClass.isNull() ? (Method)refInterface.get() : (Method)refBaseClass.get();
    }

    @NotNull
    private static Method getDeepestInterfaceMethod(@NotNull Method baseMethod) {
        if (baseMethod == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(18);
        }
        Ref refBaseInterface = new Ref();
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)baseMethod, (classMember, subClass, baseClass) -> {
            if (classMember instanceof Method) {
                refBaseInterface.set((Object)((Method)classMember));
                return true;
            }
            return false;
        });
        Method method = refBaseInterface.isNull() ? baseMethod : (Method)refBaseInterface.get();
        if (method == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(19);
        }
        return method;
    }

    @NotNull
    public static Collection<Function> getOverridingMembers(@Nullable Function function, boolean isConstructor) {
        if (isConstructor || !(function instanceof Method)) {
            Set<Function> set = Collections.singleton(function);
            if (set == null) {
                PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(20);
            }
            return set;
        }
        Method method = (Method)function;
        Project project = function.getProject();
        THashSet list = new THashSet();
        PhpClassHierarchyUtils.HierarchyClassMemberProcessor collect = (arg_0, arg_1, arg_2) -> PhpChangeSignatureUsageSearcher.lambda$getOverridingMembers$3((Set)list, arg_0, arg_1, arg_2);
        PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)method, (PhpIndex)PhpIndex.getInstance((Project)project), (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)collect);
        list.add(function);
        THashSet tHashSet = list;
        if (tHashSet == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(21);
        }
        return tHashSet;
    }

    public static boolean isReferenceFromGoalMethod(@Nullable Function parent, @NotNull Function goalMethod) {
        if (goalMethod == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(22);
        }
        if (goalMethod.equals(parent)) {
            return true;
        }
        if (!(parent instanceof Method) || !(goalMethod instanceof Method)) {
            return false;
        }
        if (((Method)goalMethod).getMethodType(false) == Method.MethodType.CONSTRUCTOR || ((Method)parent).getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
            return false;
        }
        Ref isChild = new Ref((Object)false);
        PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)((Method)goalMethod), (PhpIndex)PhpIndex.getInstance((Project)goalMethod.getProject()), (classMember, subClass, baseClass) -> {
            if (classMember.equals(parent)) {
                isChild.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)isChild.get();
    }

    private static /* synthetic */ boolean lambda$getOverridingMembers$3(Set list, PhpClassMember classMember, PhpClass subClass, PhpClass baseClass) {
        if (classMember instanceof Method) {
            list.add((Function)classMember);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageSearcher";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterOwner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFunction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseMethod";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goalMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageSearcher";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "constructDeclarationUsageInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "constructCallUsageInfo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "processAllUsages";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepestInterfaceMethod";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverridingMembers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "constructDeclarationUsageInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "constructCallUsageInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAllUsages";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getVariableFromAssignment";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestSuperMethod";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestInterfaceMethod";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceFromGoalMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

