/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.ui.xmodel.presenter;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredComponent;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.profiler.ProfilerUtil;
import com.jetbrains.php.profiler.model.ProfilerFileLocator;
import com.jetbrains.php.profiler.model.impl.ProfilerSourcePositionData;
import com.jetbrains.php.profiler.xdebug.model2.XCall;
import com.jetbrains.php.profiler.xdebug.model2.XCallable;
import com.jetbrains.php.profiler.xdebug.model2.XModel;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ProfilerNodePresenter {
    private static boolean isIncludeFunction(String functionName) {
        return Arrays.stream(XModel.INCLUDE_PREFIXES).anyMatch(functionName::startsWith);
    }

    public static void computePresentation(@NotNull SimpleColoredComponent coloredComponent, XCallable callable) {
        String functionName;
        if (coloredComponent == null) {
            ProfilerNodePresenter.$$$reportNull$$$0(0);
        }
        if ((functionName = callable.myFunctionName).startsWith("{main}")) {
            coloredComponent.append(callable.mySourcePosition.getFilePath());
            coloredComponent.setIcon(PhpIcons.PHP_FILE);
        } else {
            coloredComponent.append(functionName);
            functionName = StringUtil.trimStart((String)functionName, (String)"php::");
            if (!callable.equals(XCallable.CALLABLE_ROOT)) {
                if (ProfilerNodePresenter.isIncludeFunction(functionName)) {
                    coloredComponent.setIcon(PhpIcons.FUNCTION);
                } else if (functionName.contains("::") || functionName.contains("->")) {
                    coloredComponent.setIcon(PhpIcons.METHOD);
                } else {
                    coloredComponent.setIcon(PhpIcons.FUNCTION);
                }
            }
        }
    }

    public static PsiElement findElement(@NotNull Project project, @NotNull ProfilerFileLocator locator, XCallable callable) {
        if (project == null) {
            ProfilerNodePresenter.$$$reportNull$$$0(1);
        }
        if (locator == null) {
            ProfilerNodePresenter.$$$reportNull$$$0(2);
        }
        if (callable.myFunctionName.startsWith("{main}")) {
            return ProfilerUtil.findPsiFile(project, locator.getLocalFile(callable.mySourcePosition.getFilePath()));
        }
        ProfilerSourcePositionData sourcePosition = callable.mySourcePosition;
        if (sourcePosition != null) {
            return ProfilerUtil.findCallableAtSourcePosition(project, Function.class, locator, sourcePosition);
        }
        return null;
    }

    public static String getSearchKey(XCallable callable) {
        return callable.myFunctionName.startsWith("{main}") ? callable.mySourcePosition.getFilePath() : callable.myFunctionName;
    }

    public static void computePresentation(@NotNull SimpleColoredComponent coloredComponent, XCall call) {
        if (coloredComponent == null) {
            ProfilerNodePresenter.$$$reportNull$$$0(3);
        }
        ProfilerNodePresenter.computePresentation(coloredComponent, call.getCallable());
    }

    public static PsiElement findElement(@NotNull Project project, @NotNull ProfilerFileLocator locator, XCall call) {
        if (project == null) {
            ProfilerNodePresenter.$$$reportNull$$$0(4);
        }
        if (locator == null) {
            ProfilerNodePresenter.$$$reportNull$$$0(5);
        }
        return ProfilerNodePresenter.findElement(project, locator, call.getCallable());
    }

    public static String getSearchKey(XCall call) {
        return ProfilerNodePresenter.getSearchKey(call.getCallable());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locator";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/profiler/ui/xmodel/presenter/ProfilerNodePresenter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computePresentation";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

