/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.stubs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.config.PhpProjectConfigurableForm;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpComposerExtensionStubsInspection
extends PhpInspection {
    public boolean REQUIRE_BUNDLED_EXTENSIONS = true;

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpComposerExtensionStubsInspection.$$$reportNull$$$0(0);
        }
        HashSet excludedCategories = this.REQUIRE_BUNDLED_EXTENSIONS ? ContainerUtil.newHashSet((Object[])new PhpProjectConfigurableForm.ExtensionCategory[]{PhpProjectConfigurableForm.ExtensionCategory.CORE}) : ContainerUtil.newHashSet((Object[])new PhpProjectConfigurableForm.ExtensionCategory[]{PhpProjectConfigurableForm.ExtensionCategory.CORE, PhpProjectConfigurableForm.ExtensionCategory.BUNDLED});
        ComposerDataService dataService = ComposerDataService.getInstance(holder.getProject());
        if (dataService == null || !dataService.isConfigWellConfigured()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerExtensionStubsInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        VirtualFile config = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataService.getConfigPath());
        if (config == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerExtensionStubsInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        PhpComposerExtensionStubsInspection.saveLaterIfNeeded(config);
        final Set<String> composerExtensions = ComposerConfigUtils.getExtensions(config);
        final Set<String> composerDevExtensions = ComposerConfigUtils.getExtensions(config, true);
        if (composerExtensions == null || composerDevExtensions == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerExtensionStubsInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        Map<String, PhpProjectConfigurableForm.ExtensionCategory> extensionToCategory = PhpProjectConfigurableForm.getExtensionToCategory();
        final Map extensionMap = PhpRuntimeLibraryRootsProvider.getLibraryRoots(holder.getProject()).stream().filter(ext -> !excludedCategories.contains(extensionToCategory.get(ext.getName()))).collect(Collectors.toMap(ext -> "ext-" + StringUtil.toLowerCase((String)ext.getName()).replace(' ', '-'), Function.identity()));
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpClassReference(ClassReference classReference) {
                this.inspect((PhpReference)classReference);
            }

            public void visitPhpDocType(PhpDocType phpDocType) {
                this.inspect((PhpReference)phpDocType);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.inspect((PhpReference)reference);
            }

            public void visitPhpConstantReference(ConstantReference reference) {
                this.inspect((PhpReference)reference);
            }

            private void inspect(@NotNull PhpReference reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                SmartHashSet missedExtensions = new SmartHashSet();
                boolean dev = ProjectRootManager.getInstance((Project)reference.getProject()).getFileIndex().isInTestSourceContent(reference.getContainingFile().getVirtualFile());
                for (ResolveResult result : reference.multiResolve(false)) {
                    PsiElement element = result.getElement();
                    if (element == null) {
                        return;
                    }
                    VirtualFile file = element.getContainingFile().getVirtualFile();
                    String missedExtension = (String)ContainerUtil.find(extensionMap.keySet(), ext -> this.missedExtension((String)ext, file, dev));
                    if (missedExtension == null) {
                        return;
                    }
                    missedExtensions.add(missedExtension);
                }
                if (missedExtensions.size() > 0) {
                    String message = missedExtensions.size() == 1 ? PhpBundle.message("inspection.missing.ext.composer.json", ContainerUtil.getFirstItem((Collection)missedExtensions)) : PhpBundle.message("inspection.multiple.missing.ext.composer.json", StringUtil.join((Collection)missedExtensions, (String)", "));
                    LocalQuickFix[] fixes = (LocalQuickFix[])ContainerUtil.map2Array((Collection)missedExtensions, LocalQuickFix.class, ext -> AddToComposerJsonQuickFix.getInstance(ext, isOnTheFly, dev));
                    holder.registerProblem((PsiElement)reference, message, fixes);
                }
            }

            private boolean missedExtension(String ext, VirtualFile file, boolean inTests) {
                return (inTests ? !composerDevExtensions.contains(ext) && !composerExtensions.contains(ext) : !composerExtensions.contains(ext)) && VfsUtilCore.isAncestor((VirtualFile)((VirtualFile)extensionMap.get(ext)), (VirtualFile)file, (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$1", "inspect"));
            }
        };
        if (phpElementVisitor == null) {
            PhpComposerExtensionStubsInspection.$$$reportNull$$$0(4);
        }
        return phpElementVisitor;
    }

    private static void saveLaterIfNeeded(@NotNull VirtualFile config) {
        FileDocumentManager documentManager;
        Document document;
        if (config == null) {
            PhpComposerExtensionStubsInspection.$$$reportNull$$$0(5);
        }
        if ((document = (documentManager = FileDocumentManager.getInstance()).getDocument(config)) != null && documentManager.isDocumentUnsaved(document)) {
            ApplicationManager.getApplication().invokeLater(() -> documentManager.saveDocument(document));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveLaterIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddToComposerJsonQuickFix
    implements LocalQuickFix {
        private static final Set<AddToComposerJsonQuickFix> fixCache = new SmartHashSet();
        private final String myExtension;
        private final boolean myOnTheFly;
        private final boolean myDev;

        private AddToComposerJsonQuickFix(@NotNull String extension, boolean onTheFly, boolean dev) {
            if (extension == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(0);
            }
            this.myExtension = extension;
            this.myOnTheFly = onTheFly;
            this.myDev = dev;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("add.to.composer.json.quick.fix", this.myExtension);
            if (string == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            FileEditorManager fileManager;
            JsonObject topObject;
            if (project == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(3);
            }
            String path = ComposerDataService.getInstance(project).getConfigPath();
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            if (file == null) {
                Messages.showMessageDialog((Project)project, (String)PhpBundle.message("action.detect.composer.json.not.found", path), (String)PhpBundle.message("action.detect.composer.json.not.found.title", new Object[0]), (Icon)Messages.getWarningIcon());
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                return;
            }
            JsonFile jsonFile = (JsonFile)ObjectUtils.tryCast((Object)psiFile, JsonFile.class);
            if (jsonFile == null) {
                return;
            }
            JsonValue value = jsonFile.getTopLevelValue();
            if (value == null) {
                jsonFile.add((PsiElement)new JsonElementGenerator(project).createValue("{}"));
            }
            if ((topObject = (JsonObject)ObjectUtils.tryCast((Object)jsonFile.getTopLevelValue(), JsonObject.class)) == null) {
                return;
            }
            JsonProperty requireSection = AddToComposerJsonQuickFix.findOrCreateProperty(project, topObject, this.myDev ? "require-dev" : "require", "{}");
            JsonObject requireSectionValue = (JsonObject)requireSection.getValue();
            if (requireSectionValue == null) {
                return;
            }
            JsonProperty property = AddToComposerJsonQuickFix.findOrCreateProperty(project, requireSectionValue, this.myExtension, "\"*\"");
            if (this.myOnTheFly && (fileManager = FileEditorManager.getInstance((Project)project)) != null) {
                fileManager.openFile(file, true);
                Editor editor = fileManager.getSelectedTextEditor();
                if (editor != null) {
                    editor.getCaretModel().moveToOffset(property.getTextRange().getEndOffset());
                }
            }
        }

        private static JsonProperty findOrCreateProperty(@NotNull Project project, @NotNull JsonObject parent, @NotNull String propertyName, @NotNull String propertyValue) {
            JsonProperty property;
            if (project == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(4);
            }
            if (parent == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(5);
            }
            if (propertyName == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(6);
            }
            if (propertyValue == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(7);
            }
            if ((property = parent.findProperty(propertyName)) != null) {
                return property;
            }
            JsonElementGenerator generator = new JsonElementGenerator(project);
            property = generator.createProperty(propertyName, propertyValue);
            List list = parent.getPropertyList();
            if (list.isEmpty()) {
                parent = (JsonObject)parent.replace((PsiElement)generator.createObject(property.getText()));
                return parent.findProperty(propertyName);
            }
            PsiElement comma = parent.addAfter(generator.createComma(), (PsiElement)ContainerUtil.getLastItem((List)list));
            return (JsonProperty)parent.addAfter((PsiElement)property, comma);
        }

        public static LocalQuickFix getInstance(@NotNull String extension, boolean onTheFly, boolean dev) {
            AddToComposerJsonQuickFix fix;
            if (extension == null) {
                AddToComposerJsonQuickFix.$$$reportNull$$$0(8);
            }
            if ((fix = (AddToComposerJsonQuickFix)ContainerUtil.find(fixCache, i -> {
                if (extension == null) {
                    AddToComposerJsonQuickFix.$$$reportNull$$$0(9);
                }
                return i.myExtension.equals(extension) && i.myDev == dev && i.myOnTheFly == onTheFly;
            })) == null) {
                fix = new AddToComposerJsonQuickFix(extension, onTheFly, dev);
                fixCache.add(fix);
            }
            return fix;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$AddToComposerJsonQuickFix";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/stubs/PhpComposerExtensionStubsInspection$AddToComposerJsonQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreateProperty";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$getInstance$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class OptionsPanel {
        private JBCheckBox myRequireBundledExtensions;
        private JPanel myOptionsPanel;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myRequireBundledExtensions.setSelected(PhpComposerExtensionStubsInspection.this.REQUIRE_BUNDLED_EXTENSIONS);
            this.myRequireBundledExtensions.addChangeListener(e -> {
                PhpComposerExtensionStubsInspection.this.REQUIRE_BUNDLED_EXTENSIONS = this.myRequireBundledExtensions.isSelected();
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myRequireBundledExtensions = jBCheckBox = new JBCheckBox();
            jBCheckBox.setSelected(false);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.missing.ext.require.bundled"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

