/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayMapInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertLoopToArrayFilterQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLoopCanBeConvertedToArrayFilterInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpForeach(ForeachStatement foreach) {
                String iteratedArrayName;
                Variable key = foreach.getKey();
                if (key == null) {
                    return;
                }
                Variable value = foreach.getValue();
                if (value == null || PhpWorkaroundUtil.isReadReference((PsiElement)value)) {
                    return;
                }
                String resultArrayName = PhpLoopCanBeConvertedToArrayFilterInspection.getEmptyArrayNameDeclaredBeforeLoop((PsiElement)foreach);
                PsiElement iteratedArray = foreach.getArray();
                String string = iteratedArrayName = iteratedArray != null ? iteratedArray.getText() : null;
                if (resultArrayName == null || iteratedArrayName == null) {
                    return;
                }
                If anIf = (If)ObjectUtils.tryCast((Object)PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(foreach.getStatement()), If.class);
                if (anIf != null && anIf.getElseBranch() == null && anIf.getElseIfBranches().length == 0 && PhpLoopCanBeConvertedToArrayFilterInspection.isArrayCopying(PhpLoopCanBeConvertedToArrayMapInspection.unwrapStatement(anIf.getStatement()), resultArrayName, iteratedArrayName, key.getName(), value.getName())) {
                    holder.registerProblem(foreach.getFirstChild(), PhpBundle.message("inspection.loop.can.be.converted.to.arrayfilter", new Object[0]), new LocalQuickFix[]{PhpConvertLoopToArrayFilterQuickFix.INSTANCE});
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    @Nullable
    public static String getEmptyArrayNameDeclaredBeforeLoop(@NotNull PsiElement element) {
        AssignmentExpression arrayDeclaration;
        if (element == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(2);
        }
        PhpPsiElement array = (arrayDeclaration = PhpLoopCanBeConvertedToArrayMapInspection.getEmptyArrayDeclaration((Statement)PhpPsiUtil.getPrevSiblingByCondition(element, (Condition<? super PsiElement>)Statement.INSTANCEOF))) != null ? arrayDeclaration.getVariable() : null;
        return array != null ? array.getText() : null;
    }

    private static boolean isArrayCopying(@Nullable Statement statement, @NotNull String fromArrayName, @NotNull String toArrayName, @NotNull String keyName, @NotNull String valueName) {
        AssignmentExpression assignmentExpression;
        if (fromArrayName == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(3);
        }
        if (toArrayName == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(4);
        }
        if (keyName == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(5);
        }
        if (valueName == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(6);
        }
        if (statement != null && (assignmentExpression = (AssignmentExpression)ObjectUtils.tryCast((Object)statement.getFirstPsiChild(), AssignmentExpression.class)) != null && !(assignmentExpression instanceof SelfAssignmentExpression)) {
            PhpPsiElement value = assignmentExpression.getValue();
            ArrayAccessExpression toArray = (ArrayAccessExpression)ObjectUtils.tryCast((Object)value, ArrayAccessExpression.class);
            ArrayAccessExpression fromArray = (ArrayAccessExpression)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), ArrayAccessExpression.class);
            return PhpLoopCanBeConvertedToArrayFilterInspection.hasName(fromArray, fromArrayName) && PhpLoopCanBeConvertedToArrayFilterInspection.accessByVariableName(fromArray, keyName) && (PhpLoopCanBeConvertedToArrayFilterInspection.hasName(toArray, toArrayName) && PhpLoopCanBeConvertedToArrayFilterInspection.accessByVariableName(toArray, keyName) || PhpLoopCanBeConvertedToArrayFilterInspection.isVariableWithName((PsiElement)value, valueName));
        }
        return false;
    }

    private static boolean isVariableWithName(@Nullable PsiElement element, @NotNull String name) {
        if (name == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(7);
        }
        return element instanceof Variable && StringUtil.equals((CharSequence)((Variable)element).getName(), (CharSequence)name);
    }

    @Contract(value="null,_ -> false")
    public static boolean accessByVariableName(@Nullable ArrayAccessExpression assigneeArray, @NotNull String indexVariableName) {
        Variable accessIndexValue;
        if (indexVariableName == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(8);
        }
        return (accessIndexValue = PhpLoopCanBeConvertedToArrayFilterInspection.getIndexVariable(assigneeArray)) != null && StringUtil.equals((CharSequence)accessIndexValue.getName(), (CharSequence)indexVariableName);
    }

    @Nullable
    public static Variable getIndexVariable(ArrayAccessExpression assigneeArray) {
        ArrayIndex accessIndex = assigneeArray != null ? assigneeArray.getIndex() : null;
        return accessIndex != null ? (Variable)ObjectUtils.tryCast((Object)accessIndex.getValue(), Variable.class) : null;
    }

    @Contract(value="null,_ -> false")
    public static boolean hasName(@Nullable ArrayAccessExpression arrayAccess, @NotNull String name) {
        if (name == null) {
            PhpLoopCanBeConvertedToArrayFilterInspection.$$$reportNull$$$0(9);
        }
        PhpPsiElement array = arrayAccess != null ? arrayAccess.getValue() : null;
        return array != null && StringUtil.equals((CharSequence)array.getText(), (CharSequence)name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayFilterInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromArrayName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toArrayName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueName";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexVariableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/codeStyle/PhpLoopCanBeConvertedToArrayFilterInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEmptyArrayNameDeclaredBeforeLoop";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isArrayCopying";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVariableWithName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accessByVariableName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

