/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.debugger;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpStackFrame;
import com.jetbrains.php.debug.common.PhpSuspendContext;
import com.jetbrains.php.debug.common.smartStepInto.PhpSmartStepIntoState;
import com.jetbrains.php.debug.connection.ConnectionStatus;
import com.jetbrains.php.debug.connection.InputHandler;
import com.jetbrains.php.debug.stepFilters.PhpStepFiltersConfiguration;
import com.jetbrains.php.debug.zend.ZendDebugUtil;
import com.jetbrains.php.debug.zend.connection.ZendDebuggerConnection;
import com.jetbrains.php.debug.zend.debugger.ZendDebuggerStackFrame;
import com.jetbrains.php.debug.zend.debugger.ZendDebuggerValue;
import com.jetbrains.php.debug.zend.handlers.GetFileContentFastNotificationHandler;
import com.jetbrains.php.debug.zend.handlers.GetFileContentNotificationHandler;
import com.jetbrains.php.debug.zend.handlers.ReadyNotificationHandler;
import com.jetbrains.php.debug.zend.handlers.ScriptEndNotificationHandler;
import com.jetbrains.php.debug.zend.handlers.ZendDebuggerResponseHandler;
import com.jetbrains.php.debug.zend.messages.AddBreakpointResponse;
import com.jetbrains.php.debug.zend.messages.AddLineBreakpointRequest;
import com.jetbrains.php.debug.zend.messages.ContinueProcessFileNotification;
import com.jetbrains.php.debug.zend.messages.DeleteBreakpointRequest;
import com.jetbrains.php.debug.zend.messages.DeleteBreakpointResponse;
import com.jetbrains.php.debug.zend.messages.GetCallStackRequest;
import com.jetbrains.php.debug.zend.messages.GetCallStackResponse;
import com.jetbrains.php.debug.zend.messages.GetFileContentFastNotification;
import com.jetbrains.php.debug.zend.messages.GetFileContentNotification;
import com.jetbrains.php.debug.zend.messages.GoRequest;
import com.jetbrains.php.debug.zend.messages.OutputNotification;
import com.jetbrains.php.debug.zend.messages.PhpErrorNotification;
import com.jetbrains.php.debug.zend.messages.ReadyNotification;
import com.jetbrains.php.debug.zend.messages.ScriptEndNotification;
import com.jetbrains.php.debug.zend.messages.SessionCloseNotification;
import com.jetbrains.php.debug.zend.messages.StartProcessFileNotification;
import com.jetbrains.php.debug.zend.messages.StartRequest;
import com.jetbrains.php.debug.zend.messages.StepIntoRequest;
import com.jetbrains.php.debug.zend.messages.StepOutRequest;
import com.jetbrains.php.debug.zend.messages.StepOverRequest;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZendDebuggerDriver
extends PhpDebugDriver<ZendDebuggerConnection> {
    public static final ZendDebuggerDriver INSTANCE = new ZendDebuggerDriver();

    private ZendDebuggerDriver() {
    }

    @Override
    @NotNull
    public String getSessionIdName() {
        if ("session id" == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(0);
        }
        return "session id";
    }

    @Override
    public boolean isConditionalBreakpointSupported(XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        return false;
    }

    @Override
    public boolean isExceptionalBreakpointSupported() {
        return false;
    }

    @Override
    public void registerBreakpoint(@NotNull ZendDebuggerConnection connection, @NotNull String remoteFilePath, int line, @Nullable String condition, @NotNull String encoding, final @NotNull PhpDebugProcess.RegisterBreakpointCallback callback) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(1);
        }
        if (remoteFilePath == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(2);
        }
        if (encoding == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(4);
        }
        connection.send(new AddLineBreakpointRequest(remoteFilePath, line + 1), new ZendDebuggerResponseHandler<AddBreakpointResponse>(){

            @Override
            public void onSuccessResponse(@NotNull AddBreakpointResponse message) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                callback.registered(String.valueOf(message.getBreakpointId()));
            }

            @Override
            public void onErrorResponse(@NotNull AddBreakpointResponse message) {
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                callback.errorOccurred("Cannot add breakpoint");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "message";
                objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void registerExceptionBreakpoint(@NotNull ZendDebuggerConnection connection, @NotNull String exception, @NotNull PhpDebugProcess.RegisterBreakpointCallback callback) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(5);
        }
        if (exception == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(6);
        }
        if (callback == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(7);
        }
        callback.errorOccurred(PhpBundle.message("debug.php.exception.breakpoint.zend.not.supported", new Object[0]));
    }

    @Override
    public void unregisterBreakpoint(@NotNull ZendDebuggerConnection connection, @NotNull String breakpointId, final @NotNull PhpDebugProcess.UnregisterBreakpointCallback callback) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(8);
        }
        if (breakpointId == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(9);
        }
        if (callback == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(10);
        }
        int id = Integer.parseInt(breakpointId);
        connection.send(new DeleteBreakpointRequest(id), new ZendDebuggerResponseHandler<DeleteBreakpointResponse>(){

            @Override
            public void onSuccessResponse(@NotNull DeleteBreakpointResponse message) {
                if (message == null) {
                    2.$$$reportNull$$$0(0);
                }
                callback.unregistered();
            }

            @Override
            public void onErrorResponse(@NotNull DeleteBreakpointResponse message) {
                if (message == null) {
                    2.$$$reportNull$$$0(1);
                }
                callback.errorOccurred("Cannot remote breakpoint");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "message";
                objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onErrorResponse";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void registerAdditionalActions(@NotNull DefaultActionGroup leftToolbar, @NotNull DefaultActionGroup topToolbar, @NotNull PhpDebugProcess process) {
        if (leftToolbar == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(11);
        }
        if (topToolbar == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(12);
        }
        if (process == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(13);
        }
        topToolbar.add(ActionManager.getInstance().getAction("PhpDebugHideEmptySuperGlobals"));
    }

    @Override
    public XValueMarkerProvider<ZendDebuggerValue, String> createValueMarkerProvider() {
        return null;
    }

    @Override
    public void registerHandlers(@NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess) {
        ZendDebuggerConnection connection;
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(14);
        }
        if ((connection = debugProcess.getConnection()) == null) {
            return;
        }
        connection.registerClassHandler(ReadyNotification.class, new ReadyNotificationHandler(debugProcess));
        connection.registerClassHandler(GetFileContentNotification.class, new GetFileContentNotificationHandler(debugProcess));
        connection.registerClassHandler(GetFileContentFastNotification.class, new GetFileContentFastNotificationHandler(debugProcess));
        connection.registerClassHandler(ScriptEndNotification.class, new ScriptEndNotificationHandler(connection));
        connection.registerClassHandler(StartProcessFileNotification.class, new InputHandler<StartProcessFileNotification>(){

            @Override
            public void onResponse(@NotNull StartProcessFileNotification message) {
                if (message == null) {
                    3.$$$reportNull$$$0(0);
                }
                connection.send(new ContinueProcessFileNotification());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$3", "onResponse"));
            }
        });
    }

    @Override
    public void registerErrorOutputHandler(@NotNull ZendDebuggerConnection connection, final @NotNull PhpDebugProcess.ErrorOutputHandler handler) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(15);
        }
        if (handler == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(16);
        }
        connection.registerClassHandler(PhpErrorNotification.class, new InputHandler<PhpErrorNotification>(){

            @Override
            public void onResponse(@NotNull PhpErrorNotification message) {
                if (message == null) {
                    4.$$$reportNull$$$0(0);
                }
                String errorText = message.getText();
                String filename = message.getFilename();
                int lineNumber = message.getLineNumber();
                String errorName = ZendDebugUtil.getErrorName(message.getErrorType());
                handler.onErrorOutput(PhpBundle.message("debug.process.console.error.format", errorName, errorText, filename, String.valueOf(lineNumber)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$4", "onResponse"));
            }
        });
    }

    @Override
    public void startStepOver(@NotNull ZendDebuggerConnection connection) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(17);
        }
        connection.send(new StepOverRequest(), null);
    }

    @Override
    public void startStepInto(@NotNull ZendDebuggerConnection connection) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(18);
        }
        connection.send(new StepIntoRequest(), null);
    }

    @Override
    public void startFilteredStepInto(@NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess, @NotNull ZendDebuggerConnection connection, @NotNull PhpStepFiltersConfiguration.State state) {
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(19);
        }
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(20);
        }
        if (state == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(21);
        }
        this.startStepInto(connection);
    }

    @Override
    public void startSmartStepInto(final @NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess) {
        ZendDebuggerConnection connection;
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(22);
        }
        if ((connection = debugProcess.getConnection()) != null) {
            connection.send(new GetCallStackRequest(), new ZendDebuggerResponseHandler<GetCallStackResponse>(){

                @Override
                public void onSuccessResponse(@NotNull GetCallStackResponse message) {
                    if (message == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    List<GetCallStackResponse.StackFrame> frames = message.getStackFrames();
                    int depth = frames.size();
                    PhpSmartStepIntoState state = debugProcess.getSmartStepIntoState();
                    assert (state != null);
                    state.setInitialDepth(depth);
                    ZendDebuggerDriver.this.startStepInto(connection);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$5", "onSuccessResponse"));
                }
            });
        }
    }

    public static void onSmartStepInto(final @NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess, final @NotNull String fileName, final int currentLine) {
        ZendDebuggerConnection connection;
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(23);
        }
        if (fileName == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(24);
        }
        if ((connection = debugProcess.getConnection()) != null) {
            debugProcess.evalString("get_class($this)", new PhpDebugProcess.StringEvaluateCallback(){

                @Override
                public void evaluated(@NotNull String result) {
                    if (result == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    ZendDebuggerDriver.handleSmartStepInto(debugProcess, result, fileName, currentLine, connection);
                }

                @Override
                public void errorOccurred() {
                    ZendDebuggerDriver.handleSmartStepInto(debugProcess, null, fileName, currentLine, connection);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$6", "evaluated"));
                }
            });
        }
    }

    private static void handleSmartStepInto(final @NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess, final @Nullable String className, final @NotNull String fileName, final int currentLine, final @NotNull ZendDebuggerConnection connection) {
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(25);
        }
        if (fileName == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(26);
        }
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(27);
        }
        final PhpSmartStepIntoState state = debugProcess.getSmartStepIntoState();
        assert (state != null);
        connection.send(new GetCallStackRequest(), new ZendDebuggerResponseHandler<GetCallStackResponse>(){

            @Override
            public void onSuccessResponse(@NotNull GetCallStackResponse message) {
                if (message == null) {
                    7.$$$reportNull$$$0(0);
                }
                List<GetCallStackResponse.StackFrame> frames = message.getStackFrames();
                assert (!frames.isEmpty());
                int depth = frames.size();
                if (depth > state.getInitialDepth()) {
                    GetCallStackResponse.StackFrame firstFrame = frames.get(frames.size() - 1);
                    String name = firstFrame.getCalledFunctionName();
                    if (state.isTargetFunctionReached(className, name)) {
                        this.stopSmartStepInto(true);
                    } else {
                        connection.send(new StepOutRequest(), null);
                    }
                } else if (state.isOnStartPosition(depth, currentLine)) {
                    connection.send(new StepIntoRequest(), null);
                } else {
                    this.stopSmartStepInto(false);
                }
            }

            private void stopSmartStepInto(boolean functionAchieved) {
                debugProcess.stopSmartStepInto(functionAchieved);
                ZendDebuggerDriver.onReady(debugProcess, fileName, currentLine);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$7", "onSuccessResponse"));
            }
        });
    }

    @Override
    public void startStepOut(@NotNull ZendDebuggerConnection connection) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(28);
        }
        connection.send(new StepOutRequest(), null);
    }

    @Override
    public void resume(@NotNull ZendDebuggerConnection connection) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(29);
        }
        connection.send(new GoRequest(), null);
    }

    @Override
    public void stop(@NotNull ZendDebuggerConnection connection) {
        if (connection == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(30);
        }
        if (connection.getStatus() == ConnectionStatus.CONNECTED) {
            connection.send(new SessionCloseNotification());
            connection.stop();
        }
    }

    @Override
    public void start(@NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess) {
        ZendDebuggerConnection connection;
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(31);
        }
        if ((connection = debugProcess.getConnection()) == null) {
            return;
        }
        connection.send(new StartRequest(), null);
    }

    public static void onReady(final @NotNull PhpDebugProcess<ZendDebuggerConnection> debugProcess, final @NotNull String remoteFileName, final int lineNumber) {
        ZendDebuggerConnection connection;
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(32);
        }
        if (remoteFileName == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(33);
        }
        debugProcess.log(PhpBundle.message("debug.log.stop", remoteFileName, lineNumber));
        PhpPathMapper pathMapper = debugProcess.getPathMapper();
        if (pathMapper != null) {
            String localPath = pathMapper.getLocalPath(remoteFileName);
            debugProcess.log(PhpBundle.message("debug.log.path.mapping.remote.local", remoteFileName, localPath));
        }
        if ((connection = debugProcess.getConnection()) == null) {
            return;
        }
        connection.send(new GetCallStackRequest(), new ZendDebuggerResponseHandler<GetCallStackResponse>(){

            @Override
            public void onSuccessResponse(@NotNull GetCallStackResponse message) {
                if (message == null) {
                    8.$$$reportNull$$$0(0);
                }
                List<GetCallStackResponse.StackFrame> stackFrames = message.getStackFrames();
                int stackFramesSize = stackFrames.size();
                assert (stackFramesSize > 0);
                ArrayList<PhpStackFrame> zendStackFrames = new ArrayList<PhpStackFrame>();
                GetCallStackResponse.StackFrame topStackFrame = stackFrames.get(stackFramesSize - 1);
                Runnable reloader = () -> {
                    if (debugProcess == null) {
                        8.$$$reportNull$$$0(1);
                    }
                    if (remoteFileName == null) {
                        8.$$$reportNull$$$0(2);
                    }
                    ZendDebuggerDriver.onReady(debugProcess, remoteFileName, lineNumber);
                };
                zendStackFrames.add(new ZendDebuggerStackFrame(debugProcess, 0, stackFramesSize, remoteFileName, lineNumber, topStackFrame.getCalledFunctionName(), topStackFrame.getParameters(), reloader));
                debugProcess.log(PhpBundle.message("debug.log.stack.frame", remoteFileName, lineNumber, topStackFrame.getCalledFunctionName()));
                for (int i = stackFramesSize - 2; i > -1; --i) {
                    GetCallStackResponse.StackFrame stackFrame = stackFrames.get(i + 1);
                    String callerFileName = stackFrame.getCallerFileName();
                    int callerLineNumber = stackFrame.getCallerLineNumber();
                    String callerFunctionName = stackFrame.getCallerFunctionName();
                    int depth = stackFramesSize - i - 1;
                    debugProcess.log(PhpBundle.message("debug.log.stack.frame", callerFileName, callerLineNumber, callerFunctionName));
                    zendStackFrames.add(new ZendDebuggerStackFrame(debugProcess, depth, stackFramesSize, callerFileName, callerLineNumber, callerFunctionName, stackFrames.get(i).getParameters(), reloader));
                }
                debugProcess.onReady(new PhpSuspendContext(zendStackFrames), null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "debugProcess";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "remoteFileName";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccessResponse";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onSuccessResponse$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void registerErrorOutputHandler(final @NotNull PhpDebugProcess<? extends ZendDebuggerConnection> debugProcess) {
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(34);
        }
        ZendDebuggerConnection connection = debugProcess.getConnection();
        assert (connection != null);
        connection.registerClassHandler(PhpErrorNotification.class, new InputHandler<PhpErrorNotification>(){

            @Override
            public void onResponse(@NotNull PhpErrorNotification message) {
                if (message == null) {
                    9.$$$reportNull$$$0(0);
                }
                String errorText = message.getText();
                String filename = message.getFilename();
                int lineNumber = message.getLineNumber();
                String errorName = ZendDebugUtil.getErrorName(message.getErrorType());
                debugProcess.printErrorOutput(PhpBundle.message("debug.process.console.error.format", errorName, errorText, filename, String.valueOf(lineNumber)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$9", "onResponse"));
            }
        });
    }

    public static void registerOutputHandler(final @NotNull PhpDebugProcess<? extends ZendDebuggerConnection> debugProcess) {
        if (debugProcess == null) {
            ZendDebuggerDriver.$$$reportNull$$$0(35);
        }
        ZendDebuggerConnection connection = debugProcess.getConnection();
        assert (connection != null);
        connection.registerClassHandler(OutputNotification.class, new InputHandler<OutputNotification>(){

            @Override
            public void onResponse(@NotNull OutputNotification message) {
                if (message == null) {
                    10.$$$reportNull$$$0(0);
                }
                debugProcess.printScriptOutput(message.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver$10", "onResponse"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topToolbar";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 14: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionIdName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/zend/debugger/ZendDebuggerDriver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerBreakpoint";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerExceptionBreakpoint";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unregisterBreakpoint";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerAdditionalActions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerHandlers";
                break;
            }
            case 15: 
            case 16: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "registerErrorOutputHandler";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "startStepOver";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "startStepInto";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "startFilteredStepInto";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "startSmartStepInto";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "onSmartStepInto";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "handleSmartStepInto";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "startStepOut";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resume";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "stop";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "onReady";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "registerOutputHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

