/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComponent;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkType;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoUtil;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.ui.ResultMessage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLocalInterpreterComponent
extends PhpInterpreterComponent {
    private static final Logger LOG = Logger.getInstance(PhpLocalInterpreterComponent.class);
    private static final int TIMEOUT = 30000;
    private final DocumentAdapter myPathTextFieldListener;
    private final DocumentAdapter myDebuggerPathTextFieldListener;
    @Nullable
    private transient VirtualFile myPhpBinary;
    @NotNull
    private final Alarm myReloadAlarm;
    private boolean myDisposed;

    protected PhpLocalInterpreterComponent(@NotNull Project project, @NotNull PhpSdkAdditionalData data, @NotNull String interpreterName) {
        if (project == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(0);
        }
        if (data == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(1);
        }
        if (interpreterName == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(2);
        }
        super(project, data);
        this.myPathTextFieldListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpLocalInterpreterComponent.this.scheduleInfoComputation(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/config/interpreters/PhpLocalInterpreterComponent$1", "textChanged"));
            }
        };
        this.myDebuggerPathTextFieldListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpLocalInterpreterComponent.this.scheduleInfoComputation(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/config/interpreters/PhpLocalInterpreterComponent$2", "textChanged"));
            }
        };
        this.myPhpBinary = null;
        this.myDisposed = false;
        this.myReloadAlarm = new Alarm();
        this.myReloadAlarm.setActivationComponent((JComponent)this.myMainPanel);
        this.init(interpreterName);
    }

    @Override
    protected void init(@NotNull String interpreterName) {
        if (interpreterName == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(3);
        }
        super.init(interpreterName);
        this.myPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)this.myPathTextFieldListener);
        this.myDebuggerExtensionTextField.getTextField().getDocument().addDocumentListener((DocumentListener)this.myDebuggerPathTextFieldListener);
        this.myOptionsComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PhpLocalInterpreterComponent.this.scheduleInfoComputation(true);
            }
        });
        this.myLastLoadedInfo = PhpInterpretersPhpInfoCacheImpl.getInstance(this.myProject).getPhpInfo(interpreterName);
        this.myLastLoadedNonPersistedInfo = null;
    }

    @Override
    protected String getInterpreterPath(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(4);
        }
        if (data == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(5);
        }
        if (interpreter == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(6);
        }
        return interpreter.getHomePath();
    }

    @Override
    protected String getNewFullInterpreterPath() {
        return this.myPathTextField.getText();
    }

    private void scheduleInfoComputation(boolean reload) {
        if (this.myDisposed) {
            return;
        }
        this.myReloadAlarm.cancelAllRequests();
        this.myReloadAlarm.addComponentRequest(() -> {
            String path;
            this.myPhpBinary = PhpSdkType.getPhpBinary(this.myPathTextField.getText());
            String string = path = this.myPhpBinary == null ? "null" : this.myPhpBinary.getPresentableUrl();
            if (this.myPhpBinary != null && StringUtil.isNotEmpty((String)path) && !FileUtil.pathsEqual((String)path, (String)this.myPathTextField.getText())) {
                UIUtil.invokeAndWaitIfNeeded(() -> this.myPathTextField.setText(path));
            }
            LOG.debug("Binary file was updated: " + path + " (by " + this.myPathTextField.getText() + ")");
            if (reload) {
                this.reloadInterpreter(this.myPhpBinary);
            } else {
                this.resetPhpInfo();
            }
        }, 200);
    }

    @Override
    @Nullable
    protected ProcessOutput executeCommand(@NotNull String title, @NotNull String command) throws ExecutionException {
        if (title == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(7);
        }
        if (command == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(8);
        }
        if (this.myPhpBinary != null) {
            Ref outputRef = new Ref(null);
            Ref exceptionRef = new Ref(null);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                if (command == null) {
                    PhpLocalInterpreterComponent.$$$reportNull$$$0(20);
                }
                GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{this.myPhpBinary.getPath(), command});
                try {
                    CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    ProcessOutput output = indicator == null ? processHandler.runProcess(30000) : processHandler.runProcessWithProgressIndicator(indicator);
                    outputRef.set((Object)output);
                }
                catch (ExecutionException e) {
                    exceptionRef.set((Object)e);
                }
            }, title, true, this.myProject, (JComponent)this.myMainPanel);
            if (!exceptionRef.isNull()) {
                throw (ExecutionException)((Object)exceptionRef.get());
            }
            return (ProcessOutput)outputRef.get();
        }
        return null;
    }

    @NotNull
    public ResultMessage reloadInterpreter(@Nullable VirtualFile phpBinary) {
        ResultMessage resultMessage;
        block5: {
            if (phpBinary == null) {
                this.myLastLoadedInfo = null;
                this.myLastLoadedNonPersistedInfo = null;
                this.resetPhpInfo();
                String message = PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP executable");
                ResultMessage resultMessage2 = new ResultMessage(message, MessageType.ERROR);
                if (resultMessage2 == null) {
                    PhpLocalInterpreterComponent.$$$reportNull$$$0(9);
                }
                return resultMessage2;
            }
            try {
                List<PhpConfigurationOption> options = this.getConfigurationOption();
                Pair<PhpInfo, PhpNonPersistedInfo> wholePhpInfo = PhpInfoUtil.getWholePhpInfo(this.myProject, phpBinary.getPresentableUrl(), this.mySdkAdditionalData, options, this.myMainPanel);
                this.myLastLoadedInfo = (PhpInfo)wholePhpInfo.getFirst();
                this.myLastLoadedNonPersistedInfo = (PhpNonPersistedInfo)wholePhpInfo.getSecond();
                LOG.assertTrue(this.myLastLoadedInfo != null);
                LOG.debug("PHP Debugger was updated: " + this.myLastLoadedInfo.getDebuggers());
                this.resetPhpInfo();
                resultMessage = new ResultMessage(PhpBundle.message("PhpInterpreterConfigurable.updated.phpinfo", new Object[0]), MessageType.INFO);
                if (resultMessage != null) break block5;
            }
            catch (ExecutionException | InterruptedException e) {
                LOG.debug(e.getMessage());
                this.myLastLoadedInfo = null;
                this.myLastLoadedNonPersistedInfo = null;
                this.resetPhpInfo();
                String message = StringUtil.notNullize((String)e.getMessage(), (String)PhpBundle.message("PhpInterpreterConfigurable.can.not.updated.phpinfo", new Object[0]));
                ResultMessage resultMessage3 = new ResultMessage(message, MessageType.ERROR);
                if (resultMessage3 == null) {
                    PhpLocalInterpreterComponent.$$$reportNull$$$0(11);
                }
                return resultMessage3;
            }
            PhpLocalInterpreterComponent.$$$reportNull$$$0(10);
        }
        return resultMessage;
    }

    @Override
    @NotNull
    protected ResultMessage reloadPhpInfo() {
        ResultMessage resultMessage = this.reloadInterpreter(this.myPhpBinary);
        if (resultMessage == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(12);
        }
        return resultMessage;
    }

    @Override
    protected boolean canReloadPhpInfo() {
        return this.myReloadAlarm.getActiveRequestCount() == 0 && this.myPhpBinary != null;
    }

    @Override
    @NotNull
    protected String getPresentableInterpreterPath(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(13);
        }
        if (data == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(14);
        }
        if (interpreter == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(15);
        }
        String string = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)this.getInterpreterPath(name, data, interpreter)));
        if (string == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    public void reset(@NotNull String name, @NotNull PhpSdkAdditionalData data, @NotNull PhpInterpreter interpreter) {
        if (name == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(17);
        }
        if (data == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(18);
        }
        if (interpreter == null) {
            PhpLocalInterpreterComponent.$$$reportNull$$$0(19);
        }
        this.myPathTextField.getTextField().getDocument().removeDocumentListener((DocumentListener)this.myPathTextFieldListener);
        this.myDebuggerExtensionTextField.getTextField().getDocument().removeDocumentListener((DocumentListener)this.myDebuggerPathTextFieldListener);
        super.reset(name, data, interpreter);
        this.myDebuggerExtensionTextField.getTextField().getDocument().addDocumentListener((DocumentListener)this.myDebuggerPathTextFieldListener);
        this.myPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)this.myPathTextFieldListener);
        UIUtil.invokeLaterIfNeeded(() -> this.scheduleInfoComputation(this.myLastLoadedInfo == null || this.myLastLoadedNonPersistedInfo == null));
    }

    @Override
    public void disposeUIResources() {
        this.myPathTextField.getTextField().getDocument().removeDocumentListener((DocumentListener)this.myPathTextFieldListener);
        this.myDebuggerExtensionTextField.getTextField().getDocument().removeDocumentListener((DocumentListener)this.myDebuggerPathTextFieldListener);
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myReloadAlarm);
        super.disposeUIResources();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterName";
                break;
            }
            case 4: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpLocalInterpreterComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpLocalInterpreterComponent";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadInterpreter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadPhpInfo";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableInterpreterPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableInterpreterPath";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeCommand$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

