/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerRunningData;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerActionCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Triple;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerStatusAction
extends ComposerAbstractAction {
    @NonNls
    public static final String ID = "ComposerStatusAction";

    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerStatusAction.$$$reportNull$$$0(0);
        }
        if (configFile == null) {
            ComposerStatusAction.$$$reportNull$$$0(1);
        }
        if (placeForStatistics == null) {
            ComposerStatusAction.$$$reportNull$$$0(2);
        }
        ComposerCommandExecutor commandExecutor = ComposerStatusAction.createExecutor(project, ComposerDataService.getInstance(project), configFile, "--no-interaction --ansi --verbose", placeForStatistics);
        commandExecutor.execute();
    }

    @NotNull
    protected static ComposerCommandExecutor createExecutor(@NotNull Project project, final @NotNull ComposerRunningData runningData, final @NotNull VirtualFile configFile, final @Nullable String commandLineOptions, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerStatusAction.$$$reportNull$$$0(3);
        }
        if (runningData == null) {
            ComposerStatusAction.$$$reportNull$$$0(4);
        }
        if (configFile == null) {
            ComposerStatusAction.$$$reportNull$$$0(5);
        }
        if (placeForStatistics == null) {
            ComposerStatusAction.$$$reportNull$$$0(6);
        }
        ComposerActionStatistics actionStatistics = ComposerActionStatistics.createWithoutOptions("status", placeForStatistics);
        ComposerActionCommandExecutor.WithConfig withConfig = new ComposerActionCommandExecutor.WithConfig(project, runningData, configFile, commandLineOptions, actionStatistics, false, true){

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = ComposerUtils.getSimpleBasicCommand(runningData, "status");
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                String configFilePath = configFile.getPath();
                List<String> beginning = this.myRunningData.getComposerCommandBeginning();
                return ComposerStatusAction.createExecutorGenerator(() -> beginning, configFilePath, commandLineOptions);
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Composer found no local changes in dependencies of ").appendLink(this.myComposerJson, this.myProject).appendText(".");
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Composer found local changes in dependencies of ").appendLink(this.myComposerJson, this.myProject).appendText(".");
            }

            @Override
            protected String getProgressTitle() {
                return "Checking for Changes in Code of Dependencies";
            }

            @Override
            protected String getActionName() {
                return "status";
            }

            @Override
            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            protected String getTaskTitle() {
                if ("Checking for Changes in Code of Dependencies" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "Checking for Changes in Code of Dependencies";
            }

            @Override
            @NotNull
            protected ComposerCommandExecutor.ComposerTextListener createTextListener(@NotNull ProgressIndicator indicator, @NotNull ComposerLogMessageBuilder builder, @NotNull List<Pair<String, Key>> output) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (builder == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (output == null) {
                    1.$$$reportNull$$$0(4);
                }
                ComposerCommandExecutor.ComposerBaseTextListener composerBaseTextListener = new ComposerCommandExecutor.ComposerBaseTextListener(builder, output, indicator){
                    private boolean stdErrorShown;
                    private final Queue<Triple<String, Key, Key>> outputToShow;
                    {
                        super(builder, output, indicator);
                        this.stdErrorShown = false;
                        this.outputToShow = new LinkedList<Triple<String, Key, Key>>();
                    }

                    @Override
                    void textAvailable(@NotNull String text, @NotNull Key attributes, @NotNull Key outputType) {
                        if (text == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (attributes == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (this.stdErrorShown) {
                            super.textAvailable(text, attributes, outputType);
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            super.textAvailable(text, attributes, outputType);
                            this.stdErrorShown = true;
                            this.printOutputToShow();
                        } else {
                            this.outputToShow.add((Triple<String, Key, Key>)new Triple((Object)text, (Object)attributes, (Object)outputType));
                        }
                    }

                    private void printOutputToShow() {
                        Triple<String, Key, Key> triple = this.outputToShow.poll();
                        while (triple != null) {
                            super.textAvailable((String)triple.getFirst(), (Key)triple.getSecond(), (Key)triple.getThird());
                            triple = this.outputToShow.poll();
                        }
                    }

                    @Override
                    public void processTerminated(@NotNull ProcessEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        this.printOutputToShow();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "text";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "attributes";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                        }
                        objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerStatusAction$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "textAvailable";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                if (composerBaseTextListener == null) {
                    1.$$$reportNull$$$0(5);
                }
                return composerBaseTextListener;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerStatusAction$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "builder";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "output";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTaskTitle";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerStatusAction$1";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTextListener";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "createTextListener";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (withConfig == null) {
            ComposerStatusAction.$$$reportNull$$$0(7);
        }
        return withConfig;
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createExecutorGenerator(@NotNull ComposerRunningData data, @NotNull String configFilePath, @Nullable String commandLineOptions) {
        if (data == null) {
            ComposerStatusAction.$$$reportNull$$$0(8);
        }
        if (configFilePath == null) {
            ComposerStatusAction.$$$reportNull$$$0(9);
        }
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> {
            if (configFilePath == null) {
                ComposerStatusAction.$$$reportNull$$$0(11);
            }
            if (data == null) {
                ComposerStatusAction.$$$reportNull$$$0(12);
            }
            VirtualFile generatorConfigFile = LocalFileSystem.getInstance().findFileByPath(configFilePath);
            ComposerCommandExecutor.checkFileExists(configFilePath, generatorConfigFile);
            return ComposerStatusAction.createExecutor(generatorProject, data, generatorConfigFile, commandLineOptions, "ComposerLogRerun");
        };
        if (throwableNotNullFunction == null) {
            ComposerStatusAction.$$$reportNull$$$0(10);
        }
        return throwableNotNullFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runningData";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerStatusAction";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerStatusAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutorGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doPerformAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createExecutorGenerator";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createExecutorGenerator$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

