/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Query;
import java.util.Collection;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.quickfix.DeleteUnusedElementBase;
import org.intellij.lang.xpath.xslt.quickfix.DeleteUnusedParameterFix;
import org.intellij.lang.xpath.xslt.quickfix.DeleteUnusedVariableFix;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;

public class XsltValidator {
    private XsltValidator() {
    }

    public static void checkUnusedVariable(XsltVariable variable, ProblemsHolder holder) {
        if (variable instanceof XsltParameter ? ((XsltParameter)variable).isAbstract() : variable.isVoid()) {
            return;
        }
        XmlTag tag = variable.getTag();
        XmlTag templateTag = XsltCodeInsightUtil.getTemplateTag((PsiElement)tag, false);
        if (templateTag == null) {
            return;
        }
        XmlAttribute attribute = tag.getAttribute("name");
        if (attribute == null) {
            return;
        }
        PsiElement token = XsltSupport.getAttValueToken(attribute);
        if (token == null) {
            return;
        }
        LocalSearchScope scope = new LocalSearchScope((PsiElement)templateTag);
        Query refs = ReferencesSearch.search((PsiElement)variable, (SearchScope)scope, (boolean)false);
        if (XsltValidator.isUnused(variable, (Query<PsiReference>)refs)) {
            String name = variable.getName();
            assert (name != null);
            LocalQuickFix[] fixes = variable instanceof XsltParameter ? new LocalQuickFix[]{new DeleteUnusedParameterFix(name, (XsltParameter)variable)} : new LocalQuickFix[]{new DeleteUnusedVariableFix(name, variable)};
            holder.registerProblem(token, ((DeleteUnusedElementBase)fixes[0]).getType() + " '" + name + "' is never used", ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes);
        }
    }

    private static boolean isUnused(PsiElement obj, Query<PsiReference> query) {
        if (obj instanceof XsltParameter) {
            Collection references = query.findAll();
            int n = references.size();
            for (PsiReference reference : references) {
                XmlTag tag;
                XmlAttribute parent;
                PsiElement element = reference.getElement();
                if (!(element instanceof XmlAttributeValue) || !"name".equals((parent = (XmlAttribute)element.getParent()).getName()) || (tag = parent.getParent()) == null || !"with-param".equals(tag.getLocalName())) continue;
                --n;
            }
            return n == 0;
        }
        return query.findFirst() == null;
    }
}

