/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.refactoring.introduceVariable;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Set;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.psi.impl.XPathChangeUtil;
import org.intellij.lang.xpath.xslt.refactoring.BaseIntroduceAction;
import org.intellij.lang.xpath.xslt.refactoring.introduceVariable.IntroduceVariableDialog;
import org.intellij.lang.xpath.xslt.refactoring.introduceVariable.IntroduceVariableOptions;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;

public class XsltIntroduceVariableAction
extends BaseIntroduceAction<IntroduceVariableOptions> {
    @Override
    public String getRefactoringName() {
        return "Introduce Variable";
    }

    @Override
    protected String getCommandName() {
        return "Introduce XSLT Variable";
    }

    @Override
    protected boolean extractImpl(XPathExpression expression, Set<XPathExpression> matchingExpressions, List<XmlTag> otherMatches, IntroduceVariableOptions dlg) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)expression, XmlAttribute.class, (boolean)true);
        assert (attribute != null);
        try {
            String name = dlg.getName();
            XmlTag insertionPoint = XsltCodeInsightUtil.findVariableInsertionPoint(attribute.getParent(), XsltCodeInsightUtil.getUsageBlock(expression), name, dlg.isReplaceAll() ? otherMatches.toArray(XmlTag.EMPTY) : XmlTag.EMPTY);
            XmlTag parentTag = insertionPoint.getParentTag();
            assert (parentTag != null) : "Could not locate position to create variable at";
            XmlTag xmlTag = parentTag.createChildTag("variable", "http://www.w3.org/1999/XSL/Transform", null, false);
            xmlTag.setAttribute("name", name);
            xmlTag.setAttribute("select", expression.getText());
            PsiElement element = parentTag.addBefore((PsiElement)xmlTag, (PsiElement)insertionPoint);
            ASTNode node1 = parentTag.getNode();
            assert (node1 != null);
            ASTNode node2 = element.getNode();
            assert (node2 != null);
            CodeStyleManager.getInstance((Project)xmlTag.getManager().getProject()).reformatNewlyAddedElement(node1, node2);
            XPathVariableReference var = XPathChangeUtil.createVariableReference(expression, name);
            expression.replace(var);
            if (dlg.isReplaceAll()) {
                for (XPathExpression expr : matchingExpressions) {
                    expr.replace(XPathChangeUtil.createVariableReference(expr, name));
                }
                return false;
            }
            return true;
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
            return false;
        }
    }

    @Override
    protected IntroduceVariableOptions getSettings(XPathExpression expression, Set<XPathExpression> matchingExpressions) {
        IntroduceVariableDialog dlg = new IntroduceVariableDialog(expression, matchingExpressions.size() + 1);
        dlg.show();
        return dlg;
    }
}

