/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ext.LibraryDependentToolWindow;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.messages.MessageBusConnection;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class LibraryDependentToolWindowManager
implements StartupActivity {
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"LibraryDependentToolWindowManager");

    public void runActivity(final @NotNull Project project) {
        Application application;
        if (project == null) {
            LibraryDependentToolWindowManager.$$$reportNull$$$0(0);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        ModuleRootListener rootListener = new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                LibraryDependentToolWindowManager.checkToolWindowStatuses(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/LibraryDependentToolWindowManager$1", "rootsChanged"));
            }
        };
        LibraryDependentToolWindowManager.checkToolWindowStatuses(project);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)rootListener);
    }

    private static void checkToolWindowStatuses(@NotNull Project project) {
        if (project == null) {
            LibraryDependentToolWindowManager.$$$reportNull$$$0(1);
        }
        ModalityState currentModalityState = ModalityState.current();
        ourExecutor.submit(() -> {
            if (project == null) {
                LibraryDependentToolWindowManager.$$$reportNull$$$0(7);
            }
            LibraryDependentToolWindowManager.doCheckToolWindowStatuses(project, currentModalityState);
        });
    }

    private static void doCheckToolWindowStatuses(@NotNull Project project, ModalityState currentModalityState) {
        DumbService dumbService;
        if (project == null) {
            LibraryDependentToolWindowManager.$$$reportNull$$$0(2);
        }
        if ((dumbService = (DumbService)ReadAction.compute(() -> {
            if (project == null) {
                LibraryDependentToolWindowManager.$$$reportNull$$$0(6);
            }
            return project.isDisposed() ? null : DumbService.getInstance((Project)project);
        })) == null) {
            return;
        }
        for (LibraryDependentToolWindow libraryToolWindow : LibraryDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList()) {
            boolean finished2;
            Ref libraryExists = Ref.create((Object)false);
            Runnable runnable2 = () -> {
                if (project == null) {
                    LibraryDependentToolWindowManager.$$$reportNull$$$0(4);
                }
                Boolean exists = (Boolean)dumbService.runReadActionInSmartMode(() -> {
                    if (project == null) {
                        LibraryDependentToolWindowManager.$$$reportNull$$$0(5);
                    }
                    return !project.isDisposed() && libraryToolWindow.getLibrarySearchHelper().isLibraryExists(project);
                });
                libraryExists.set((Object)exists);
            };
            while (!project.isDisposed() && !(finished2 = ProgressIndicatorUtils.runWithWriteActionPriority(runnable2, new ProgressIndicatorBase()))) {
                ProgressIndicatorUtils.yieldToPendingWriteActions();
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    LibraryDependentToolWindowManager.$$$reportNull$$$0(3);
                }
                ToolWindowManagerEx toolWindowManagerEx = ToolWindowManagerEx.getInstanceEx(project);
                ToolWindow toolWindow = toolWindowManagerEx.getToolWindow(libraryToolWindow.id);
                if (((Boolean)libraryExists.get()).booleanValue()) {
                    if (toolWindow == null) {
                        toolWindowManagerEx.initToolWindow((ToolWindowEP)libraryToolWindow);
                    }
                } else if (toolWindow != null) {
                    toolWindowManagerEx.unregisterToolWindow(libraryToolWindow.id);
                }
            }, currentModalityState, project.getDisposed());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/openapi/wm/impl/LibraryDependentToolWindowManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkToolWindowStatuses";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheckToolWindowStatuses";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doCheckToolWindowStatuses$4";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doCheckToolWindowStatuses$3";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$2";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$doCheckToolWindowStatuses$1";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$checkToolWindowStatuses$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

