/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.Patches;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClipboardAnalyzeListener
implements ApplicationActivationListener {
    private static final int MAX_SIZE = 102400;
    @Nullable
    private String myCachedClipboardValue;

    public void applicationActivated(@NotNull IdeFrame ideFrame) {
        if (ideFrame == null) {
            ClipboardAnalyzeListener.$$$reportNull$$$0(0);
        }
        Runnable processClipboard = () -> {
            String clipboard;
            if (ideFrame == null) {
                ClipboardAnalyzeListener.$$$reportNull$$$0(2);
            }
            if ((clipboard = ClipboardUtil.getTextInClipboard()) != null && clipboard.length() < 102400 && !clipboard.equals(this.myCachedClipboardValue)) {
                this.myCachedClipboardValue = clipboard;
                Project project = ideFrame.getProject();
                if (project != null && !project.isDefault() && this.canHandle(this.myCachedClipboardValue)) {
                    this.handle(project, this.myCachedClipboardValue);
                }
            }
        };
        if (Patches.SLOW_GETTING_CLIPBOARD_CONTENTS) {
            new Alarm().addRequest(processClipboard, 300);
        } else {
            processClipboard.run();
        }
    }

    protected abstract void handle(@NotNull Project var1, @NotNull String var2);

    public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
        if (ideFrame == null) {
            ClipboardAnalyzeListener.$$$reportNull$$$0(1);
        }
        this.myCachedClipboardValue = ClipboardUtil.getTextInClipboard();
    }

    public abstract boolean canHandle(@NotNull String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "ideFrame";
        objectArray2[1] = "com/intellij/openapi/application/ClipboardAnalyzeListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applicationActivated";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applicationDeactivated";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$applicationActivated$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

