/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class DumpVfsInfoForExcludedFilesAction
extends DumbAwareAction {
    public DumpVfsInfoForExcludedFilesAction() {
        super("Dump VFS content for files under excluded roots");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DumpVfsInfoForExcludedFilesAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        HashSet<String> excludeRoots = new HashSet<String>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Collections.addAll(excludeRoots, ModuleRootManager.getInstance((Module)module).getExcludeRootUrls());
        }
        for (Module module : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)project)) {
            for (VirtualFile file2 : module.getExcludeRootsForProject()) {
                excludeRoots.add(file2.getUrl());
            }
        }
        if (excludeRoots.isEmpty()) {
            System.out.println("No excluded roots found in project.");
        }
        for (String root : excludeRoots) {
            VirtualFile file3 = VirtualFileManager.getInstance().findFileByUrl(root);
            if (file3 == null) {
                System.out.println(root + " not in VFS");
                continue;
            }
            DumpVfsInfoForExcludedFilesAction.dumpChildrenInDbRecursively(file3, 0);
        }
    }

    private static void dumpChildrenInDbRecursively(VirtualFile dir, int depth) {
        if (!(dir instanceof NewVirtualFile)) {
            System.out.println(dir.getPresentableUrl() + ": not in db (" + dir.getClass().getName() + ")");
            return;
        }
        ArrayList<NewVirtualFile> dirs = new ArrayList<NewVirtualFile>();
        int inDb = 0;
        int contentInDb = 0;
        int nullChildren = 0;
        PersistentFS persistentFS = PersistentFS.getInstance();
        if (persistentFS.wereChildrenAccessed(dir)) {
            for (String name : persistentFS.listPersisted(dir)) {
                ++inDb;
                NewVirtualFile child2 = ((NewVirtualFile)dir).refreshAndFindChild(name);
                if (child2 == null) {
                    ++nullChildren;
                    continue;
                }
                if (child2.isDirectory()) {
                    dirs.add(child2);
                    continue;
                }
                if (PersistentFS.getInstance().getCurrentContentId((VirtualFile)child2) == 0) continue;
                ++contentInDb;
            }
        }
        System.out.print(dir.getPresentableUrl() + ": " + inDb + " children in db");
        if (contentInDb > 0) {
            System.out.print(", content of " + contentInDb + " files in db");
        }
        if (nullChildren > 0) {
            System.out.print(", " + nullChildren + " invalid files in db");
        }
        System.out.println();
        if (depth > 10) {
            System.out.println("too deep, skipping children");
        } else {
            for (VirtualFile virtualFile : dirs) {
                DumpVfsInfoForExcludedFilesAction.dumpChildrenInDbRecursively(virtualFile, depth + 1);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/DumpVfsInfoForExcludedFilesAction", "actionPerformed"));
    }
}

