/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJButtonBorder;
import com.intellij.ide.ui.laf.intellij.MacIntelliJTextBorder;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class MacIntelliJButtonUI
extends DarculaButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJButtonUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        if (!(c.getBorder() instanceof MacIntelliJButtonBorder)) {
            super.paint(g, c);
            return;
        }
        int w = c.getWidth();
        int h = c.getHeight();
        if (UIUtil.isHelpButton((Component)c)) {
            Icon icon = LafIconLookup.getIcon((String)"helpButton", (boolean)false, (boolean)c.hasFocus(), (boolean)true);
            int x = (w - icon.getIconWidth()) / 2;
            int y = (h - icon.getIconHeight()) / 2;
            icon.paintIcon(c, g, x, y);
        } else {
            AbstractButton b = (AbstractButton)c;
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.translate(0, 0);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                float lw = MacIntelliJTextBorder.LW(g2);
                float arc = MacIntelliJTextBorder.ARC.getFloat();
                Object i = MacIntelliJButtonUI.isSmallComboButton(c) ? JBUI.insets((int)1) : c.getInsets();
                RoundRectangle2D.Float outerRect = new RoundRectangle2D.Float(i.left, i.top, w - (i.left + i.right), h - (i.top + i.bottom), arc, arc);
                g2.setPaint(MacIntelliJButtonUI.getBackgroundPaint(c));
                g2.fill(outerRect);
                Path2D.Float outline = new Path2D.Float(0);
                outline.append(outerRect, false);
                outline.append(new RoundRectangle2D.Float((float)i.left + lw, (float)i.top + lw, (float)w - lw * 2.0f - (float)(i.left + i.right), (float)h - lw * 2.0f - (float)(i.top + i.bottom), arc - lw, arc - lw), false);
                g2.setPaint(MacIntelliJButtonUI.getBorderPaint(c));
                g2.fill(outline);
                this.paintContents(g2, b);
            }
            finally {
                g2.dispose();
            }
        }
    }

    private static Paint getBackgroundPaint(JComponent b) {
        int h = b.getHeight();
        Insets i = b.getInsets();
        if (!b.isEnabled()) {
            return Gray.xF1;
        }
        if (MacIntelliJButtonUI.isDefaultButton(b)) {
            return UIUtil.isGraphite() ? new GradientPaint(0.0f, i.top, new Color(0xB2B2B7), 0.0f, h - (i.top + i.bottom), new Color(0x929297)) : new GradientPaint(0.0f, i.top, new Color(6861562), 0.0f, b.getHeight() - (i.top + i.bottom), new Color(950527));
        }
        Color backgroundColor = (Color)b.getClientProperty("JButton.backgroundColor");
        return backgroundColor != null ? backgroundColor : Gray.xFF;
    }

    public static Paint getBorderPaint(JComponent b) {
        int h = b.getHeight();
        Insets i = b.getBorder().getBorderInsets(b);
        if (!b.isEnabled()) {
            return new GradientPaint(0.0f, i.top, (Color)Gray.xD2, 0.0f, h - (i.top + i.bottom), (Color)Gray.xC3);
        }
        if (MacIntelliJButtonUI.isDefaultButton(b)) {
            return UIUtil.isGraphite() ? new GradientPaint(0.0f, i.top, new Color(0xA5A5AB), 0.0f, h - (i.top + i.bottom), new Color(8224131)) : new GradientPaint(0.0f, i.top, new Color(4956408), 0.0f, h - (i.top + i.bottom), new Color(614143));
        }
        Color borderColor = (Color)b.getClientProperty("JButton.borderColor");
        return borderColor != null ? borderColor : new GradientPaint(0.0f, i.top, (Color)Gray.xC9, 0.0f, h - (i.top + i.bottom), (Color)Gray.xAC);
    }

    @Override
    protected Dimension getDarculaButtonSize(JComponent c, Dimension prefSize) {
        if (UIUtil.isHelpButton((Component)c)) {
            Icon icon = LafIconLookup.getIcon((String)"helpButton");
            return new Dimension(icon.getIconWidth(), icon.getIconHeight());
        }
        Insets i = c.getInsets();
        return new Dimension(MacIntelliJButtonUI.getComboAction(c) != null ? prefSize.width : Math.max(HORIZONTAL_PADDING.get() * 2 + prefSize.width, MINIMUM_BUTTON_WIDTH.get() + i.left + i.right), Math.max(prefSize.height, this.getMinimumHeight() + i.top + i.bottom));
    }

    @Override
    protected int getMinimumHeight() {
        return MacIntelliJTextBorder.MINIMUM_HEIGHT.get();
    }

    @Override
    protected void paintDisabledText(Graphics g, String text, JComponent c, Rectangle textRect, FontMetrics metrics) {
        int x = textRect.x + this.getTextShiftOffset();
        int y = textRect.y + metrics.getAscent() + this.getTextShiftOffset();
        if (MacIntelliJButtonUI.isDefaultButton(c)) {
            g.setColor((Color)Gray.xCC);
        } else {
            g.setColor(UIManager.getColor("Button.disabledText"));
        }
        UIUtilities.drawStringUnderlineCharAt((JComponent)c, (Graphics)g, (String)text, (int)-1, (int)x, (int)y);
    }
}

