/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class InspectionTreeState {
    private final Set<Object> myExpandedUserObjects = new HashSet<Object>();
    private InspectionTreeSelectionPath mySelectionPath;

    public Set<Object> getExpandedUserObjects() {
        return this.myExpandedUserObjects;
    }

    public void setSelectionPath(TreePath selectionPath) {
        this.mySelectionPath = new InspectionTreeSelectionPath(selectionPath);
    }

    public void restoreExpansionAndSelection(InspectionTree tree, boolean treeNodeMightChange) {
        this.restoreExpansionStatus((InspectionTreeNode)tree.getModel().getRoot(), tree);
        if (this.mySelectionPath != null) {
            this.mySelectionPath.restore(tree, treeNodeMightChange);
        } else {
            TreeUtil.selectFirstNode((JTree)((Object)tree));
        }
    }

    private void restoreExpansionStatus(InspectionTreeNode node, InspectionTree tree) {
        if (this.getExpandedUserObjects().contains(node.getUserObject())) {
            Object[] pathToNode = node.getPath();
            tree.expandPath(new TreePath(pathToNode));
            Enumeration<TreeNode> children2 = node.children();
            while (children2.hasMoreElements()) {
                InspectionTreeNode childNode = (InspectionTreeNode)children2.nextElement();
                this.restoreExpansionStatus(childNode, tree);
            }
        }
    }

    private static class InspectionTreeSelectionPath {
        private final Object[] myPath;
        private final int[] myIndices;

        InspectionTreeSelectionPath(TreePath path) {
            this.myPath = path.getPath();
            this.myIndices = new int[this.myPath.length];
            for (int i = 0; i < this.myPath.length - 1; ++i) {
                InspectionTreeNode node = (InspectionTreeNode)this.myPath[i];
                this.myIndices[i + 1] = InspectionTreeSelectionPath.getChildIndex(node, (InspectionTreeNode)this.myPath[i + 1]);
            }
        }

        private static int getChildIndex(InspectionTreeNode node, InspectionTreeNode child2) {
            InspectionTreeNode ch;
            int idx = 0;
            Enumeration<TreeNode> children2 = node.children();
            while (children2.hasMoreElements() && (ch = (InspectionTreeNode)children2.nextElement()) != child2) {
                ++idx;
            }
            return idx;
        }

        public void restore(InspectionTree tree, boolean treeNodeMightChange) {
            tree.getSelectionModel().removeSelectionPaths(tree.getSelectionModel().getSelectionPaths());
            TreeUtil.selectPath((JTree)((Object)tree), (TreePath)this.restorePath(tree, treeNodeMightChange));
        }

        private TreePath restorePath(InspectionTree tree, boolean treeNodeMightChange) {
            ArrayList<Object> newPath = new ArrayList<Object>();
            newPath.add(tree.getModel().getRoot());
            this.restorePath(newPath, 1, treeNodeMightChange);
            return new TreePath(newPath.toArray());
        }

        private void restorePath(ArrayList<Object> newPath, int idx, boolean treeNodeMightChange) {
            if (idx >= this.myPath.length) {
                return;
            }
            InspectionTreeNode oldNode = (InspectionTreeNode)this.myPath[idx];
            InspectionTreeNode newRoot = (InspectionTreeNode)newPath.get(idx - 1);
            Enumeration<TreeNode> children2 = newRoot.children();
            while (children2.hasMoreElements()) {
                InspectionTreeNode child2 = (InspectionTreeNode)children2.nextElement();
                if (!(treeNodeMightChange ? InspectionResultsViewComparator.getInstance().areEqual(child2, oldNode) : child2 == oldNode)) continue;
                newPath.add(child2);
                this.restorePath(newPath, idx + 1, treeNodeMightChange);
                return;
            }
            int count = newRoot.getChildCount();
            if (count > 0) {
                if (this.myIndices[idx] < count) {
                    newPath.add(newRoot.getChildAt(this.myIndices[idx]));
                } else {
                    newPath.add(newRoot.getChildAt(count - 1));
                }
            }
        }
    }
}

