/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker;

import com.intellij.docker.DockerMappingConfigurable;
import com.intellij.docker.agent.settings.DockerPathMapping;
import com.intellij.docker.agent.settings.DockerPathMappingImpl;
import com.intellij.docker.settings.TableWithCardEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.remoteServer.util.Column;

public class DockerPathMappingEditor
extends TableWithCardEditor<DockerPathMappingImpl, ColumnBase> {
    public DockerPathMappingEditor() {
        super((Column[])new ColumnBase[]{new VirtualMachinePathColumn(), new LocalPathColumn()});
    }

    @Override
    protected DockerPathMappingImpl createItem() {
        return new DockerPathMappingImpl();
    }

    @Override
    protected DockerPathMappingImpl cloneItem(DockerPathMappingImpl item) {
        return new DockerPathMappingImpl((DockerPathMapping)item);
    }

    @Override
    protected Configurable createItemConfigurable(DockerPathMappingImpl item) {
        return new DockerMappingConfigurable(item);
    }

    private static class LocalPathColumn
    extends ColumnBase {
        LocalPathColumn() {
            super("Local path");
        }

        public Object getColumnValue(DockerPathMappingImpl row) {
            return row.getLocalPath();
        }
    }

    private static class VirtualMachinePathColumn
    extends ColumnBase {
        VirtualMachinePathColumn() {
            super("Virtual machine path");
        }

        public Object getColumnValue(DockerPathMappingImpl row) {
            return row.getVirtualMachinePath();
        }
    }

    public static abstract class ColumnBase
    extends Column<DockerPathMappingImpl> {
        public ColumnBase(String name) {
            super(name);
        }
    }
}

