/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlTagUtilBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTagUtil
extends XmlTagUtilBase {
    private static final Map<String, Character> ourCharacterEntities = new HashMap<String, Character>();

    public static String getCDATAQuote(String text) {
        if (text == null) {
            return null;
        }
        String offensiveChars = "<>&\n";
        int textLength = text.length();
        if (textLength > 0 && (Character.isWhitespace(text.charAt(0)) || Character.isWhitespace(text.charAt(textLength - 1)))) {
            return "<![CDATA[" + text + "]]>";
        }
        for (int i = 0; i < offensiveChars.length(); ++i) {
            char c = offensiveChars.charAt(i);
            if (text.indexOf(c) == -1) continue;
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    public static String getInlineQuote(String text) {
        if (text == null) {
            return null;
        }
        String offensiveChars = "<>&";
        for (int i = 0; i < offensiveChars.length(); ++i) {
            char c = offensiveChars.charAt(i);
            if (text.indexOf(c) == -1) continue;
            return "<![CDATA[" + text + "]]>";
        }
        return text;
    }

    public static CharSequence composeTagText(@NonNls String tagName, @NonNls String tagValue) {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(tagName);
        if (StringUtil.isEmpty((String)tagValue)) {
            builder.append("/>");
        } else {
            builder.append('>').append(XmlTagUtil.getCDATAQuote(tagValue)).append("</").append(tagName).append('>');
        }
        return builder;
    }

    public static String[] getCharacterEntityNames() {
        Set<String> strings = ourCharacterEntities.keySet();
        return ArrayUtil.toStringArray(strings);
    }

    public static Character getCharacterByEntityName(String entityName) {
        return ourCharacterEntities.get(entityName);
    }

    @Nullable
    public static XmlToken getStartTagNameElement(@NotNull XmlTag tag) {
        IElementType elementType;
        ASTNode current;
        ASTNode node;
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(0);
        }
        if ((node = tag.getNode()) == null) {
            return null;
        }
        for (current = node.getFirstChildNode(); current != null && (elementType = current.getElementType()) != XmlTokenType.XML_NAME && elementType != XmlTokenType.XML_TAG_NAME; current = current.getTreeNext()) {
        }
        return current == null ? null : (XmlToken)current.getPsi();
    }

    @Nullable
    public static XmlToken getEndTagNameElement(@NotNull XmlTag tag) {
        ASTNode current;
        ASTNode node;
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(1);
        }
        if ((node = tag.getNode()) == null) {
            return null;
        }
        ASTNode prev = current = node.getLastChildNode();
        while (current != null) {
            IElementType elementType = prev.getElementType();
            if ((elementType == XmlTokenType.XML_NAME || elementType == XmlTokenType.XML_TAG_NAME) && current.getElementType() == XmlTokenType.XML_END_TAG_START) {
                return (XmlToken)prev.getPsi();
            }
            prev = current;
            current = current.getTreePrev();
        }
        return null;
    }

    @NotNull
    public static TextRange getTrimmedValueRange(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(2);
        }
        XmlTagValue tagValue = tag.getValue();
        String text = tagValue.getText();
        String trimmed = text.trim();
        int index2 = text.indexOf(trimmed);
        int startOffset = tagValue.getTextRange().getStartOffset() - tag.getTextRange().getStartOffset() + index2;
        TextRange textRange = new TextRange(startOffset, startOffset + trimmed.length());
        if (textRange == null) {
            XmlTagUtil.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Nullable
    public static TextRange getStartTagRange(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(4);
        }
        XmlToken tagName = XmlTagUtil.getStartTagNameElement(tag);
        return XmlTagUtil.getTagRange(tagName, XmlTokenType.XML_START_TAG_START);
    }

    @Nullable
    public static TextRange getEndTagRange(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagUtil.$$$reportNull$$$0(5);
        }
        XmlToken tagName = XmlTagUtil.getEndTagNameElement(tag);
        return XmlTagUtil.getTagRange(tagName, XmlTokenType.XML_END_TAG_START);
    }

    @Nullable
    private static TextRange getTagRange(@Nullable XmlToken tagName, IElementType tagStart) {
        PsiElement f;
        PsiElement s;
        if (tagName == null) {
            return null;
        }
        for (s = tagName.getPrevSibling(); s != null && s.getNode().getElementType() != tagStart; s = s.getPrevSibling()) {
        }
        for (f = tagName.getNextSibling(); f != null && f.getNode().getElementType() != XmlTokenType.XML_TAG_END && f.getNode().getElementType() != XmlTokenType.XML_EMPTY_ELEMENT_END; f = f.getNextSibling()) {
        }
        if (s != null && f != null) {
            return new TextRange(s.getTextRange().getStartOffset(), f.getTextRange().getEndOffset());
        }
        return null;
    }

    static {
        ourCharacterEntities.put("lt", Character.valueOf('<'));
        ourCharacterEntities.put("gt", Character.valueOf('>'));
        ourCharacterEntities.put("apos", Character.valueOf('\''));
        ourCharacterEntities.put("quot", Character.valueOf('\"'));
        ourCharacterEntities.put("nbsp", Character.valueOf('\u00a0'));
        ourCharacterEntities.put("amp", Character.valueOf('&'));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/XmlTagUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/XmlTagUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimmedValueRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStartTagNameElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEndTagNameElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTrimmedValueRange";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStartTagRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEndTagRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

