/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractFilterChildren;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.checkin.CheckinClient;
import org.jetbrains.idea.svn.checkin.CommitEventHandler;
import org.jetbrains.idea.svn.checkin.CommitEventType;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.checkin.IdeaCommitHandler;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusType;

public class CmdCheckinClient
extends BaseSvnClient
implements CheckinClient {
    private static final Logger LOG = Logger.getInstance(CmdCheckinClient.class);
    public static final long INVALID_REVISION_NUMBER = -1L;

    @Override
    @NotNull
    public CommitInfo[] commit(@NotNull List<File> paths, @NotNull String message) throws VcsException {
        if (paths == null) {
            CmdCheckinClient.$$$reportNull$$$0(0);
        }
        if (message == null) {
            CmdCheckinClient.$$$reportNull$$$0(1);
        }
        paths = this.filterCommittables(paths);
        CommitInfo[] commitInfoArray = this.runCommit(paths, message);
        if (commitInfoArray == null) {
            CmdCheckinClient.$$$reportNull$$$0(2);
        }
        return commitInfoArray;
    }

    @NotNull
    private CommitInfo[] runCommit(@NotNull List<File> paths, @NotNull String message) throws VcsException {
        if (paths == null) {
            CmdCheckinClient.$$$reportNull$$$0(3);
        }
        if (message == null) {
            CmdCheckinClient.$$$reportNull$$$0(4);
        }
        if (ContainerUtil.isEmpty(paths)) {
            CommitInfo[] commitInfoArray = new CommitInfo[]{CommitInfo.EMPTY};
            if (commitInfoArray == null) {
                CmdCheckinClient.$$$reportNull$$$0(5);
            }
            return commitInfoArray;
        }
        Command command = this.newCommand(SvnCommandName.ci);
        command.put(Depth.EMPTY);
        command.put("-m", message);
        ContainerUtil.sort(paths);
        command.setTargets(paths);
        IdeaCommitHandler handler = new IdeaCommitHandler(ProgressManager.getInstance().getProgressIndicator());
        CommandListener listener = new CommandListener(handler);
        listener.setBaseDirectory(CommandUtil.requireExistingParent(paths.get(0)));
        this.execute(this.myVcs, Target.on(paths.get(0)), null, command, (LineCommandListener)listener);
        listener.throwExceptionIfOccurred();
        long revision = CmdCheckinClient.validateRevisionNumber(listener.getCommittedRevision());
        CommitInfo[] commitInfoArray = new CommitInfo[]{new CommitInfo.Builder().setRevision(revision).build()};
        if (commitInfoArray == null) {
            CmdCheckinClient.$$$reportNull$$$0(6);
        }
        return commitInfoArray;
    }

    private static long validateRevisionNumber(long revision) throws VcsException {
        if (revision < 0L) {
            throw new VcsException("Wrong committed revision number: " + revision);
        }
        return revision;
    }

    @NotNull
    private List<File> filterCommittables(@NotNull List<File> committables) throws SvnBindException {
        if (committables == null) {
            CmdCheckinClient.$$$reportNull$$$0(7);
        }
        final HashSet childrenOfSomebody = ContainerUtil.newHashSet();
        new AbstractFilterChildren<File>(){

            protected void sortAscending(List<File> list) {
                Collections.sort(list);
            }

            protected boolean isAncestor(File parent, File child) {
                boolean isAncestor = FileUtil.isAncestor((File)parent, (File)child, (boolean)true);
                if (isAncestor) {
                    childrenOfSomebody.add(child.getPath());
                }
                return isAncestor;
            }
        }.doFilter((List)ContainerUtil.newArrayList(committables));
        if (!childrenOfSomebody.isEmpty()) {
            ArrayList result = ContainerUtil.newArrayList();
            StatusClient statusClient = this.myFactory.createStatusClient();
            for (File file : committables) {
                if (!childrenOfSomebody.contains(file.getPath())) {
                    result.add(file);
                    continue;
                }
                try {
                    Status status = statusClient.doStatus(file, false);
                    if (status == null || StatusType.STATUS_NONE.equals((Object)status.getContentsStatus()) || StatusType.STATUS_UNVERSIONED.equals((Object)status.getContentsStatus())) continue;
                    result.add(file);
                }
                catch (SvnBindException e) {
                    LOG.info((Throwable)((Object)e));
                    throw e;
                }
            }
            ArrayList arrayList = result;
            if (arrayList == null) {
                CmdCheckinClient.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        List<File> list = committables;
        if (list == null) {
            CmdCheckinClient.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/checkin/CmdCheckinClient";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "committables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/checkin/CmdCheckinClient";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "commit";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runCommit";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterCommittables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runCommit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterCommittables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CommandListener
    extends LineCommandAdapter {
        private static final String STATUS = "\\s*(\\w+)(.*?)\\s\\s+";
        private static final String OPTIONAL_FILE_TYPE = "(\\(.*\\))?";
        private static final String PATH = "\\s*(.*?)\\s*";
        private static final Pattern CHANGED_PATH = Pattern.compile("\\s*(\\w+)(.*?)\\s\\s+(\\(.*\\))?\\s*(.*?)\\s*");
        @Nullable
        private final CommitEventHandler myHandler;
        private SvnBindException myException;
        private long myCommittedRevision = -1L;
        private File myBase;

        public CommandListener(@Nullable CommitEventHandler handler) {
            this.myHandler = handler;
        }

        public void throwExceptionIfOccurred() throws VcsException {
            if (this.myException != null) {
                throw this.myException;
            }
        }

        public long getCommittedRevision() {
            return this.myCommittedRevision;
        }

        public void setBaseDirectory(@NotNull File file) {
            if (file == null) {
                CommandListener.$$$reportNull$$$0(0);
            }
            this.myBase = file;
        }

        @Override
        public void onLineAvailable(String line, Key outputType) {
            String trim = line.trim();
            if (ProcessOutputTypes.STDOUT.equals((Object)outputType)) {
                try {
                    this.parseLine(trim);
                }
                catch (SvnBindException e) {
                    this.myException = e;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void parseLine(String line) throws SvnBindException {
            if (StringUtil.isEmptyOrSpaces((String)line)) {
                return;
            }
            if (line.startsWith(CommitEventType.transmittingDeltas.getText())) {
                if (this.myHandler == null) return;
                this.myHandler.commitEvent(CommitEventType.transmittingDeltas, this.myBase);
                return;
            }
            if (line.startsWith(CommitEventType.skipped.getText())) {
                int pathEnd;
                File target = null;
                if (this.myHandler == null) return;
                int pathStart = line.indexOf(39);
                if (pathStart > -1 && (pathEnd = line.indexOf(39, pathStart + 1)) > -1) {
                    target = this.toFile(line.substring(pathStart + 1, pathEnd));
                }
                if (target != null) {
                    this.myHandler.commitEvent(CommitEventType.skipped, this.myBase);
                    return;
                }
                LOG.info("Can not parse 'Skipped' path " + line);
                return;
            }
            if (line.startsWith(CommitEventType.committedRevision.getText())) {
                String substring = line.substring(CommitEventType.committedRevision.getText().length());
                int cnt = 0;
                while (StringUtil.isWhiteSpace((char)substring.charAt(cnt))) {
                    ++cnt;
                }
                StringBuilder num = new StringBuilder();
                while (Character.isDigit(substring.charAt(cnt))) {
                    num.append(substring.charAt(cnt));
                    ++cnt;
                }
                if (num.length() <= 0) {
                    String message = "Missing committed revision number: " + num.toString() + ", string: " + line;
                    LOG.info(message);
                    throw new SvnBindException(message);
                }
                try {
                    this.myCommittedRevision = Long.parseLong(num.toString());
                    if (this.myHandler == null) return;
                    this.myHandler.committedRevision(this.myCommittedRevision);
                    return;
                }
                catch (NumberFormatException e) {
                    String message = "Wrong committed revision number: " + num.toString() + ", string: " + line;
                    LOG.info(message, (Throwable)e);
                    throw new SvnBindException(message);
                }
            }
            if (this.myHandler == null) {
                return;
            }
            Matcher matcher = CHANGED_PATH.matcher(line);
            if (!matcher.matches()) {
                LOG.info("Can not parse output: " + line);
                return;
            }
            CommitEventType type = CommitEventType.create(matcher.group(1));
            if (type == null) {
                LOG.info("Can not parse event type: " + line);
                return;
            }
            this.myHandler.commitEvent(type, this.toFile(matcher.group(4)));
        }

        @NotNull
        private File toFile(@NotNull String path) {
            if (path == null) {
                CommandListener.$$$reportNull$$$0(1);
            }
            File file = SvnUtil.resolvePath(this.myBase, path);
            if (file == null) {
                CommandListener.$$$reportNull$$$0(2);
            }
            return file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/checkin/CmdCheckinClient$CommandListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/checkin/CmdCheckinClient$CommandListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setBaseDirectory";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toFile";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

