/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import javax.xml.bind.annotation.XmlEnum;
import org.jetbrains.annotations.NotNull;

@XmlEnum
public enum NodeKind {
    UNKNOWN("unknown"),
    FILE("file"),
    DIR("dir"),
    NONE("none");

    @NotNull
    private static final Map<String, NodeKind> ourAllNodeKinds;
    @NotNull
    private final String myKey;

    private NodeKind(String key) {
        if (key == null) {
            NodeKind.$$$reportNull$$$0(0);
        }
        this.myKey = key;
    }

    public boolean isFile() {
        return FILE.equals((Object)this);
    }

    public boolean isDirectory() {
        return DIR.equals((Object)this);
    }

    public boolean isNone() {
        return NONE.equals((Object)this);
    }

    public String toString() {
        return this.myKey;
    }

    private static void register(@NotNull NodeKind kind) {
        if (kind == null) {
            NodeKind.$$$reportNull$$$0(1);
        }
        ourAllNodeKinds.put(kind.myKey, kind);
    }

    @NotNull
    public static NodeKind from(@NotNull String nodeKindName) {
        NodeKind result;
        if (nodeKindName == null) {
            NodeKind.$$$reportNull$$$0(2);
        }
        if ((result = ourAllNodeKinds.get(nodeKindName)) == null) {
            throw new IllegalArgumentException("Unknown node kind " + nodeKindName);
        }
        NodeKind nodeKind = result;
        if (nodeKind == null) {
            NodeKind.$$$reportNull$$$0(3);
        }
        return nodeKind;
    }

    @NotNull
    public static NodeKind from(boolean isDirectory) {
        NodeKind nodeKind = isDirectory ? DIR : FILE;
        if (nodeKind == null) {
            NodeKind.$$$reportNull$$$0(4);
        }
        return nodeKind;
    }

    static {
        ourAllNodeKinds = ContainerUtil.newHashMap();
        for (NodeKind kind : NodeKind.values()) {
            NodeKind.register(kind);
        }
        ourAllNodeKinds.put("", UNKNOWN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeKindName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/api/NodeKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/api/NodeKind";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

