/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ConflictState;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnChangedFile;
import org.jetbrains.idea.svn.SvnContentRevision;
import org.jetbrains.idea.svn.SvnLocallyDeletedChange;
import org.jetbrains.idea.svn.SvnStatusConvertor;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.ShowPropertiesDiffAction;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.SimplePropertyRevision;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

class SvnChangeProviderContext
implements StatusReceiver {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.idea.svn.SvnChangeProviderContext");
    @NotNull
    private final ChangelistBuilder myChangelistBuilder;
    @NotNull
    private final List<SvnChangedFile> myCopiedFiles;
    @NotNull
    private final List<SvnChangedFile> myDeletedFiles;
    @NotNull
    private final Map<String, Status> myTreeConflicted;
    @NotNull
    private final Map<FilePath, Url> myCopyFromURLs;
    @NotNull
    private final SvnVcs myVcs;
    private final SvnBranchConfigurationManager myBranchConfigurationManager;
    @NotNull
    private final List<File> filesToRefresh;
    @Nullable
    private final ProgressIndicator myProgress;

    SvnChangeProviderContext(@NotNull SvnVcs vcs, @NotNull ChangelistBuilder changelistBuilder, @Nullable ProgressIndicator progress) {
        if (vcs == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(0);
        }
        if (changelistBuilder == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(1);
        }
        this.myCopiedFiles = ContainerUtil.newArrayList();
        this.myDeletedFiles = ContainerUtil.newArrayList();
        this.myTreeConflicted = ContainerUtil.newHashMap();
        this.myCopyFromURLs = ContainerUtil.newHashMap();
        this.filesToRefresh = ContainerUtil.newArrayList();
        this.myVcs = vcs;
        this.myChangelistBuilder = changelistBuilder;
        this.myProgress = progress;
        this.myBranchConfigurationManager = SvnBranchConfigurationManager.getInstance(this.myVcs.getProject());
    }

    @Override
    public void process(FilePath path, Status status) throws SvnBindException {
        if (status != null) {
            this.processStatusFirstPass(path, status);
        }
    }

    @Override
    public void processIgnored(VirtualFile vFile) {
        this.myChangelistBuilder.processIgnoredFile(vFile);
    }

    @Override
    public void processUnversioned(VirtualFile vFile) {
        this.myChangelistBuilder.processUnversionedFile(vFile);
    }

    @Override
    public void processCopyRoot(VirtualFile file, Url url, WorkingCopyFormat format, Url rootURL) {
    }

    @Override
    public void bewareRoot(VirtualFile vf, Url url) {
    }

    @Override
    public void finish() {
        LocalFileSystem.getInstance().refreshIoFiles(this.filesToRefresh, true, false, null);
    }

    @NotNull
    public ChangelistBuilder getBuilder() {
        ChangelistBuilder changelistBuilder = this.myChangelistBuilder;
        if (changelistBuilder == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(2);
        }
        return changelistBuilder;
    }

    public void reportTreeConflict(@NotNull Status status) {
        if (status == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(3);
        }
        this.myTreeConflicted.put(status.getFile().getAbsolutePath(), status);
    }

    @Nullable
    public Status getTreeConflictStatus(@NotNull File file) {
        if (file == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(4);
        }
        return this.myTreeConflicted.get(file.getAbsolutePath());
    }

    @NotNull
    public List<SvnChangedFile> getCopiedFiles() {
        List<SvnChangedFile> list = this.myCopiedFiles;
        if (list == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<SvnChangedFile> getDeletedFiles() {
        List<SvnChangedFile> list = this.myDeletedFiles;
        if (list == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(6);
        }
        return list;
    }

    public boolean isDeleted(@NotNull FilePath path) {
        if (path == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(7);
        }
        for (SvnChangedFile deletedFile : this.myDeletedFiles) {
            if (!Comparing.equal((Object)path, (Object)deletedFile.getFilePath())) continue;
            return true;
        }
        return false;
    }

    public void checkCanceled() {
        if (this.myProgress != null) {
            this.myProgress.checkCanceled();
        }
    }

    @Nullable
    public Url getParentCopyFromURL(@NotNull FilePath filePath) throws SvnBindException {
        FilePath parent;
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(8);
        }
        Url result = null;
        for (parent = filePath; parent != null && !this.myCopyFromURLs.containsKey(parent); parent = parent.getParentPath()) {
        }
        if (parent != null) {
            Url copyFromUrl = this.myCopyFromURLs.get(parent);
            result = parent == filePath ? copyFromUrl : SvnUtil.append(copyFromUrl, SvnUtil.getRelativePath(parent.getPath(), filePath.getPath()));
        }
        return result;
    }

    public void addCopiedFile(@NotNull FilePath filePath, @NotNull Status status, @NotNull Url copyFromURL) {
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(9);
        }
        if (status == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(10);
        }
        if (copyFromURL == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(11);
        }
        this.myCopiedFiles.add(new SvnChangedFile(filePath, status, copyFromURL));
        ContainerUtil.putIfNotNull((Object)filePath, (Object)status.getCopyFromURL(), this.myCopyFromURLs);
    }

    void processStatusFirstPass(@NotNull FilePath filePath, @NotNull Status status) throws SvnBindException {
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(12);
        }
        if (status == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(13);
        }
        if (status.getRemoteLock() != null) {
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), status.getRemoteLock().toLogicalLock(false));
        }
        if (status.getLocalLock() != null) {
            this.myChangelistBuilder.processLogicallyLockedFolder(filePath.getVirtualFile(), status.getLocalLock().toLogicalLock(true));
        }
        if (filePath.isDirectory() && status.isLocked()) {
            this.myChangelistBuilder.processLockedFolder(filePath.getVirtualFile());
        }
        if ((status.is(StatusType.STATUS_ADDED) || StatusType.STATUS_MODIFIED.equals((Object)status.getNodeStatus())) && status.getCopyFromURL() != null) {
            this.addCopiedFile(filePath, status, status.getCopyFromURL());
        } else if (status.is(StatusType.STATUS_DELETED)) {
            this.myDeletedFiles.add(new SvnChangedFile(filePath, status));
        } else {
            Url parentCopyFromURL = this.getParentCopyFromURL(filePath);
            if (parentCopyFromURL != null) {
                this.addCopiedFile(filePath, status, parentCopyFromURL);
            } else {
                this.processStatus(filePath, status);
            }
        }
    }

    void processStatus(@NotNull FilePath filePath, @NotNull Status status) throws SvnBindException {
        WorkingCopyFormat format;
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(14);
        }
        if (status == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(15);
        }
        if (!WorkingCopyFormat.UNKNOWN.equals((Object)(format = this.myVcs.getWorkingCopyFormat(filePath.getIOFile()))) && format.less(WorkingCopyFormat.ONE_DOT_SEVEN)) {
            this.loadEntriesFile(filePath);
        }
        FileStatus fStatus = SvnStatusConvertor.convertStatus(status);
        StatusType statusType = status.getContentsStatus();
        if (status.is(StatusType.STATUS_UNVERSIONED, StatusType.UNKNOWN)) {
            VirtualFile file = filePath.getVirtualFile();
            if (file != null) {
                this.myChangelistBuilder.processUnversionedFile(file);
            }
        } else if (status.is(StatusType.STATUS_ADDED)) {
            this.processChangeInList(null, CurrentContentRevision.create((FilePath)filePath), fStatus, status);
        } else if (status.is(StatusType.STATUS_CONFLICTED, StatusType.STATUS_MODIFIED, StatusType.STATUS_REPLACED) || status.isProperty(StatusType.STATUS_MODIFIED, StatusType.STATUS_CONFLICTED)) {
            this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), fStatus, status);
            this.checkSwitched(filePath, status, fStatus);
        } else if (status.is(StatusType.STATUS_DELETED)) {
            this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), null, fStatus, status);
        } else if (status.is(StatusType.STATUS_MISSING)) {
            this.myChangelistBuilder.processLocallyDeletedFile((LocallyDeletedChange)new SvnLocallyDeletedChange(filePath, this.getState(status)));
        } else if (status.is(StatusType.STATUS_IGNORED)) {
            VirtualFile file = filePath.getVirtualFile();
            if (file == null) {
                file = LocalFileSystem.getInstance().refreshAndFindFileByPath(filePath.getPath());
            }
            if (file == null) {
                LOG.error("No virtual file for ignored file: " + filePath.getPresentableUrl() + ", isNonLocal: " + filePath.isNonLocal());
            } else if (!this.myVcs.isWcRoot(filePath)) {
                this.myChangelistBuilder.processIgnoredFile(filePath.getVirtualFile());
            }
        } else if ((fStatus == FileStatus.NOT_CHANGED || fStatus == FileStatus.SWITCHED) && statusType != StatusType.STATUS_NONE) {
            VirtualFile file = filePath.getVirtualFile();
            if (file != null && FileDocumentManager.getInstance().isFileModified(file)) {
                this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status);
            } else if (status.getTreeConflict() != null) {
                this.myChangelistBuilder.processChange(this.createChange(SvnContentRevision.createBaseRevision(this.myVcs, filePath, status), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, status), SvnVcs.getKey());
            }
            this.checkSwitched(filePath, status, fStatus);
        }
    }

    public void addModifiedNotSavedChange(@NotNull VirtualFile file) throws SvnBindException {
        if (file == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(16);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        Info svnInfo = this.myVcs.getInfo(file);
        if (svnInfo != null) {
            Status svnStatus = new Status();
            svnStatus.setRevision(svnInfo.getRevision());
            svnStatus.setKind(NodeKind.from(filePath.isDirectory()));
            this.processChangeInList(SvnContentRevision.createBaseRevision(this.myVcs, filePath, svnInfo.getRevision()), CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED, svnStatus);
        }
    }

    private void processChangeInList(@Nullable ContentRevision beforeRevision, @Nullable ContentRevision afterRevision, @NotNull FileStatus fileStatus, @NotNull Status status) throws SvnBindException {
        if (fileStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(17);
        }
        if (status == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(18);
        }
        Change change = this.createChange(beforeRevision, afterRevision, fileStatus, status);
        this.myChangelistBuilder.processChangeInList(change, SvnUtil.getChangelistName(status), SvnVcs.getKey());
    }

    private void checkSwitched(@NotNull FilePath filePath, @NotNull Status status, @NotNull FileStatus convertedStatus) {
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(19);
        }
        if (status == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(20);
        }
        if (convertedStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(21);
        }
        if (status.isSwitched() || convertedStatus == FileStatus.SWITCHED) {
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            Url switchUrl = status.getURL();
            VirtualFile vcsRoot = ProjectLevelVcsManager.getInstance((Project)this.myVcs.getProject()).getVcsRootFor(virtualFile);
            if (vcsRoot != null) {
                String baseUrl = this.myBranchConfigurationManager.get(vcsRoot).getBaseName(switchUrl);
                this.myChangelistBuilder.processSwitchedFile(virtualFile, baseUrl == null ? switchUrl.toDecodedString() : baseUrl, true);
            }
        }
    }

    private void loadEntriesFile(@NotNull FilePath filePath) {
        FilePath parentPath;
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(22);
        }
        if ((parentPath = filePath.getParentPath()) == null) {
            return;
        }
        this.refreshDotSvnAndEntries(parentPath);
        if (filePath.isDirectory()) {
            this.refreshDotSvnAndEntries(filePath);
        }
    }

    private void refreshDotSvnAndEntries(@NotNull FilePath filePath) {
        if (filePath == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(23);
        }
        File svn = new File(filePath.getPath(), SvnUtil.SVN_ADMIN_DIR_NAME);
        this.filesToRefresh.add(svn);
        this.filesToRefresh.add(new File(svn, "entries"));
    }

    @NotNull
    Change createMovedChange(@NotNull ContentRevision before, @NotNull ContentRevision after, @Nullable Status copiedStatus, @NotNull Status deletedStatus) throws SvnBindException {
        if (before == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(24);
        }
        if (after == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(25);
        }
        if (deletedStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(26);
        }
        ConflictedSvnChange change = new ConflictedSvnChange(before, after, ConflictState.mergeState(this.getState(copiedStatus), this.getState(deletedStatus)), copiedStatus != null && copiedStatus.getTreeConflict() != null ? after.getFile() : before.getFile());
        change.setBeforeDescription(deletedStatus.getTreeConflict());
        if (copiedStatus != null) {
            change.setAfterDescription(copiedStatus.getTreeConflict());
            this.patchWithPropertyChange(change, copiedStatus, deletedStatus);
        }
        ConflictedSvnChange conflictedSvnChange = change;
        if (conflictedSvnChange == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(27);
        }
        return conflictedSvnChange;
    }

    @NotNull
    private Change createChange(@Nullable ContentRevision before, @Nullable ContentRevision after, @NotNull FileStatus fStatus, @NotNull Status svnStatus) throws SvnBindException {
        if (fStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(28);
        }
        if (svnStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(29);
        }
        ConflictedSvnChange change = new ConflictedSvnChange(before, after, fStatus, this.getState(svnStatus), after == null ? before.getFile() : after.getFile());
        change.setIsPhantom(StatusType.STATUS_DELETED.equals((Object)svnStatus.getNodeStatus()) && !svnStatus.getRevision().isValid());
        change.setBeforeDescription(svnStatus.getTreeConflict());
        this.patchWithPropertyChange(change, svnStatus, null);
        ConflictedSvnChange conflictedSvnChange = change;
        if (conflictedSvnChange == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(30);
        }
        return conflictedSvnChange;
    }

    private void patchWithPropertyChange(@NotNull Change change, @NotNull Status svnStatus, @Nullable Status deletedStatus) throws SvnBindException {
        if (change == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(31);
        }
        if (svnStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(32);
        }
        if (svnStatus.isProperty(StatusType.STATUS_CONFLICTED, StatusType.CHANGED, StatusType.STATUS_ADDED, StatusType.STATUS_DELETED, StatusType.STATUS_MODIFIED, StatusType.STATUS_REPLACED, StatusType.MERGED)) {
            change.addAdditionalLayerElement("Property", this.createPropertyChange(change, svnStatus, deletedStatus));
        }
    }

    @NotNull
    private Change createPropertyChange(@NotNull Change change, @NotNull Status svnStatus, @Nullable Status deletedStatus) throws SvnBindException {
        if (change == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(33);
        }
        if (svnStatus == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(34);
        }
        File ioFile = ChangesUtil.getFilePath((Change)change).getIOFile();
        File beforeFile = deletedStatus != null ? deletedStatus.getFile() : ioFile;
        ContentRevision beforeRevision = !svnStatus.isProperty(StatusType.STATUS_ADDED) || deletedStatus != null ? this.createPropertyRevision(change, beforeFile, true) : null;
        ContentRevision afterRevision = !svnStatus.isProperty(StatusType.STATUS_DELETED) ? this.createPropertyRevision(change, ioFile, false) : null;
        FileStatus status = deletedStatus != null ? FileStatus.MODIFIED : SvnStatusConvertor.convertPropertyStatus(svnStatus.getPropertiesStatus());
        Change change2 = new Change(beforeRevision, afterRevision, status);
        if (change2 == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(35);
        }
        return change2;
    }

    @Nullable
    private ContentRevision createPropertyRevision(@NotNull Change change, @NotNull File file, boolean isBeforeRevision) throws SvnBindException {
        if (change == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(36);
        }
        if (file == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(37);
        }
        FilePath path = ChangesUtil.getFilePath((Change)change);
        ContentRevision contentRevision = isBeforeRevision ? change.getBeforeRevision() : change.getAfterRevision();
        Revision revision = isBeforeRevision ? Revision.BASE : Revision.WORKING;
        return new SimplePropertyRevision(ShowPropertiesDiffAction.getPropertyList(this.myVcs, file, revision), path, SvnChangeProviderContext.getRevisionNumber(contentRevision));
    }

    @Nullable
    private static String getRevisionNumber(@Nullable ContentRevision revision) {
        return revision != null ? revision.getRevisionNumber().asString() : null;
    }

    @NotNull
    private ConflictState getState(@Nullable Status svnStatus) {
        ConflictState result;
        ConflictState conflictState = result = svnStatus != null ? ConflictState.from(svnStatus) : ConflictState.none;
        if (result.isTree()) {
            this.reportTreeConflict(svnStatus);
        }
        ConflictState conflictState2 = result;
        if (conflictState2 == null) {
            SvnChangeProviderContext.$$$reportNull$$$0(38);
        }
        return conflictState2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 27: 
            case 30: 
            case 35: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 27: 
            case 30: 
            case 35: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changelistBuilder";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 27: 
            case 30: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnChangeProviderContext";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 4: 
            case 16: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFromURL";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatus";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertedStatus";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedStatus";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fStatus";
                break;
            }
            case 29: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svnStatus";
                break;
            }
            case 31: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnChangeProviderContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopiedFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeletedFiles";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createMovedChange";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createChange";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createPropertyChange";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 27: 
            case 30: 
            case 35: 
            case 38: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reportTreeConflict";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTreeConflictStatus";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDeleted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentCopyFromURL";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addCopiedFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processStatusFirstPass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processStatus";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addModifiedNotSavedChange";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processChangeInList";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkSwitched";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadEntriesFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "refreshDotSvnAndEntries";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createMovedChange";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "patchWithPropertyChange";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyChange";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 27: 
            case 30: 
            case 35: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

