/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.inspections.suppress;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressAllForAtRuleCommentFix;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressAllForMixinCommentFix;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressAllForRulesetCommentFix;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressForAtRuleCommentFix;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressForMixinCommentFix;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressForRulesetCommentFix;
import org.jetbrains.plugins.less.inspections.suppress.LessSuppressForStatementCommentFix;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LessParameter;
import org.jetbrains.plugins.less.psi.LessRuleset;
import org.jetbrains.plugins.less.psi.LessStatement;

public class LessSuppressionUtil {
    public static boolean isSuppressedFor(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            LessSuppressionUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            return true;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (toolId == null) {
                LessSuppressionUtil.$$$reportNull$$$0(16);
            }
            if (LessSuppressionUtil.getSuppressedInCssStatement(element, toolId) != null) {
                return true;
            }
            if (LessSuppressionUtil.getSuppressedInLessStatement(element, toolId) != null) {
                return true;
            }
            if (LessSuppressionUtil.getSuppressedInCssRuleset(element, toolId) != null) {
                return true;
            }
            if (LessSuppressionUtil.getSuppressedInLessRuleset(element, toolId) != null) {
                return true;
            }
            if (LessSuppressionUtil.getSuppressedInBlockAtRule(element, toolId) != null) {
                return true;
            }
            return false;
        });
    }

    @Nullable
    public static PsiElement getSuppressibleStatement(@Nullable PsiElement context) {
        PsiElement statement = PsiTreeUtil.getTopmostParentOfType((PsiElement)context, CssOneLineStatement.class);
        if (statement != null && statement.getParent() instanceof LessParameter) {
            return null;
        }
        return statement;
    }

    @Nullable
    public static PsiElement getSuppressibleCssRuleset(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssRuleset.class});
    }

    @Nullable
    public static PsiElement getSuppressibleMixin(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{LESSMixin.class});
    }

    @Nullable
    public static PsiElement getSuppressibleAtRule(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssAtRule.class});
    }

    @Nullable
    private static PsiElement getSuppressedInLessStatement(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            LessSuppressionUtil.$$$reportNull$$$0(1);
        }
        if (toolId == null) {
            LessSuppressionUtil.$$$reportNull$$$0(2);
        }
        return LessSuppressionUtil.getStatementToolSuppressedIn(element, toolId, LessStatement.class);
    }

    @Nullable
    private static PsiElement getSuppressedInCssStatement(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            LessSuppressionUtil.$$$reportNull$$$0(3);
        }
        if (toolId == null) {
            LessSuppressionUtil.$$$reportNull$$$0(4);
        }
        return LessSuppressionUtil.getStatementToolSuppressedIn(element, toolId, CssOneLineStatement.class);
    }

    @Nullable
    private static PsiElement getSuppressedInLessRuleset(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            LessSuppressionUtil.$$$reportNull$$$0(5);
        }
        if (toolId == null) {
            LessSuppressionUtil.$$$reportNull$$$0(6);
        }
        return LessSuppressionUtil.getStatementToolSuppressedIn(element, toolId, LessRuleset.class);
    }

    @Nullable
    private static PsiElement getSuppressedInCssRuleset(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            LessSuppressionUtil.$$$reportNull$$$0(7);
        }
        if (toolId == null) {
            LessSuppressionUtil.$$$reportNull$$$0(8);
        }
        return LessSuppressionUtil.getStatementToolSuppressedIn(element, toolId, CssRuleset.class);
    }

    @Nullable
    private static PsiElement getSuppressedInBlockAtRule(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            LessSuppressionUtil.$$$reportNull$$$0(9);
        }
        if (toolId == null) {
            LessSuppressionUtil.$$$reportNull$$$0(10);
        }
        return LessSuppressionUtil.getStatementToolSuppressedIn(element, toolId, CssAtRule.class);
    }

    @Nullable
    private static PsiElement getStatementToolSuppressedIn(@NotNull PsiElement element, @NotNull String toolId, @NotNull Class<? extends PsiElement> statementClass) {
        if (element == null) {
            LessSuppressionUtil.$$$reportNull$$$0(11);
        }
        if (toolId == null) {
            LessSuppressionUtil.$$$reportNull$$$0(12);
        }
        if (statementClass == null) {
            LessSuppressionUtil.$$$reportNull$$$0(13);
        }
        PsiElement current = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{statementClass});
        while (current != null) {
            PsiElement result = SuppressionUtil.getStatementToolSuppressedIn((PsiElement)current, (String)toolId, statementClass);
            if (result != null) {
                return result;
            }
            current = PsiTreeUtil.getParentOfType((PsiElement)current, statementClass, (boolean)true);
        }
        return null;
    }

    @NotNull
    public static SuppressQuickFix[] getSuppressActions(@NotNull String toolId) {
        if (toolId == null) {
            LessSuppressionUtil.$$$reportNull$$$0(14);
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new LessSuppressForStatementCommentFix(toolId), new LessSuppressForRulesetCommentFix(toolId), new LessSuppressForMixinCommentFix(toolId), new LessSuppressForAtRuleCommentFix(toolId), new LessSuppressAllForRulesetCommentFix(), new LessSuppressAllForMixinCommentFix(), new LessSuppressAllForAtRuleCommentFix()};
        if (suppressQuickFixArray == null) {
            LessSuppressionUtil.$$$reportNull$$$0(15);
        }
        return suppressQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/less/inspections/suppress/LessSuppressionUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInLessStatement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInCssStatement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInLessRuleset";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInCssRuleset";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInBlockAtRule";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStatementToolSuppressedIn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isSuppressedFor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

