/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui.download;

import a.b.lb;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ui.download.AdditionalDownloadableLibraryProvider;
import com.intellij.webcore.libraries.ui.download.DefaultDownloadableWebLibrariesSource;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import com.intellij.webcore.libraries.ui.download.DownloadableWebLibrariesSource;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadWebLibraryDialog
extends DialogWrapper {
    private JPanel b;
    private JBTable c;
    private JLabel a;
    private DownloadableFileSetDescriptionWithUrl d;
    private static final long e = lb.a(5285058908188823292L, -1637013721215584126L, MethodHandles.lookup().lookupClass()).a(275225567764460L);

    public DownloadWebLibraryDialog(@NotNull Project project, LangScriptingContextProvider provider) {
        long l3 = e ^ 0x7A944ABC49E3L;
        if (project == null) {
            DownloadWebLibraryDialog.a(0);
        }
        super(project);
        this.a();
        this.setTitle("Download Library");
        this.setOKButtonText("Download and Install");
        this.setCancelButtonText("Close");
        this.setOKActionEnabled(false);
        this.c.setSelectionMode(0);
        DefaultComboBoxModel<DefaultDownloadableWebLibrariesSource> defaultComboBoxModel = new DefaultComboBoxModel<DefaultDownloadableWebLibrariesSource>();
        defaultComboBoxModel.addElement(new DefaultDownloadableWebLibrariesSource(project, provider));
        DownloadableWebLibrariesSource downloadableWebLibrariesSource = AdditionalDownloadableLibraryProvider.getLibrary(project);
        if (downloadableWebLibrariesSource != null) {
            this.a.setText(downloadableWebLibrariesSource.toString());
            this.a(project, downloadableWebLibrariesSource, provider);
        }
        this.init();
        TableColumnModel tableColumnModel = this.c.getColumnModel();
        int[] nArray = new int[]{100, 20, 300};
        for (int i10 = 0; i10 < tableColumnModel.getColumnCount(); ++i10) {
            tableColumnModel.getColumn(i10).setPreferredWidth(nArray[i10]);
        }
        new TableSpeedSearch((JTable)this.c).setComparator(new SpeedSearchComparator(true));
        this.c.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e10) {
                TableModel tableModel = DownloadWebLibraryDialog.this.c.getModel();
                if (tableModel instanceof MyLibraryTableModel) {
                    DownloadWebLibraryDialog.this.setOKActionEnabled(true);
                    DownloadWebLibraryDialog.this.d = ((MyLibraryTableModel)tableModel).getDescriptionAt(DownloadWebLibraryDialog.this.c.getSelectedRow());
                }
            }
        });
    }

    private void a(final @NotNull Project project, final @NotNull DownloadableWebLibrariesSource downloadableWebLibrariesSource, final @NotNull LangScriptingContextProvider langScriptingContextProvider) {
        long l3 = e ^ 0x2440CC32ACL;
        if (project == null) {
            DownloadWebLibraryDialog.a(1);
        }
        if (downloadableWebLibrariesSource == null) {
            DownloadWebLibraryDialog.a(2);
        }
        if (langScriptingContextProvider == null) {
            DownloadWebLibraryDialog.a(3);
        }
        final DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[]{"Fetching a list of libraries..."}, 1){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.setOKActionEnabled(false);
        this.c.setModel((TableModel)defaultTableModel);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (downloadableWebLibrariesSource == null) {
                DownloadWebLibraryDialog.a(4);
            }
            if (langScriptingContextProvider == null) {
                DownloadWebLibraryDialog.a(5);
            }
            if (project == null) {
                DownloadWebLibraryDialog.a(6);
            }
            downloadableWebLibrariesSource.prepareTableModel(new DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescriptionWithUrl>(){
                private static final long a = lb.a(-993613836638331892L, 6225009120446099798L, MethodHandles.lookup().lookupClass()).a(14086718023875L);

                public void onSuccess(@NotNull List<? extends DownloadableFileSetDescriptionWithUrl> versions) {
                    if (versions == null) {
                        3.a(0);
                    }
                    if (versions.size() > 0) {
                        langScriptingContextProvider.filterExistingLibraries(project, versions);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (versions == null) {
                                3.a(3);
                            }
                            if (downloadableWebLibrariesSource == null) {
                                3.a(4);
                            }
                            DownloadWebLibraryDialog.this.c.setModel((TableModel)new MyLibraryTableModel(versions, downloadableWebLibrariesSource.includeVersionColumn()));
                        }, ModalityState.any());
                    }
                }

                public void onError(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        3.a(1);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        long l3 = a ^ 0x621395F4725DL;
                        if (errorMessage == null) {
                            3.a(2);
                        }
                        defaultTableModel.setColumnIdentifiers(new Object[]{"Error while fetching list of libraries: " + errorMessage});
                    }, ModalityState.any());
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    long l3 = a ^ 0x6DBEA62C6B70L;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "versions";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "errorMessage";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "librariesSource";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog$3";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onSuccess";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onError";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onError$1";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onSuccess$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        });
    }

    @Nullable
    protected String getHelpId() {
        long l3 = e ^ 0x50BBAAF606AL;
        return "JavaScript.Libraries";
    }

    protected JComponent createCenterPanel() {
        return this.b;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.b;
    }

    @Nullable
    public DownloadableFileSetDescriptionWithUrl getSelection() {
        return this.d;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l3 = e ^ 0x43A5B280CC64L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesSource";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "populate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$populate$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void a() {
        JLabel jLabel;
        JBTable jBTable;
        JPanel jPanel;
        long l3 = e ^ 0x5C91B31FC97CL;
        this.b = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.c = jBTable = new JBTable();
        jBTable.setAutoResizeMode(2);
        jBTable.setStriped(true);
        jBScrollPane.setViewportView((Component)jBTable);
        this.a = jLabel = new JLabel();
        jLabel.setText("No libraries available");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.b;
    }

    private static class MyLibraryTableModel
    extends AbstractTableModel {
        private final int c;
        private final int d;
        private final int a;
        private final List<? extends DownloadableFileSetDescriptionWithUrl> b;
        private final boolean e;
        private static final long f = lb.a(-6594178478435775761L, 4376295242351952642L, MethodHandles.lookup().lookupClass()).a(217376145738600L);

        MyLibraryTableModel(List<? extends DownloadableFileSetDescriptionWithUrl> descriptions, boolean includeVersionColumn) {
            this.b = descriptions;
            this.e = includeVersionColumn;
            this.c = 0;
            this.d = this.e ? 1 : -1;
            this.a = this.e ? 2 : 1;
            Collections.sort(this.b, (downloadableFileSetDescription, downloadableFileSetDescription2) -> {
                if (downloadableFileSetDescription.getName().equals(downloadableFileSetDescription2.getName())) {
                    return downloadableFileSetDescription.getVersionString().compareTo(downloadableFileSetDescription2.getVersionString());
                }
                return downloadableFileSetDescription.getName().compareToIgnoreCase(downloadableFileSetDescription2.getName());
            });
        }

        @Override
        public int getRowCount() {
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.e ? 3 : 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            DownloadableFileSetDescriptionWithUrl downloadableFileSetDescriptionWithUrl = this.b.get(rowIndex);
            if (columnIndex == this.c) {
                return downloadableFileSetDescriptionWithUrl.getName();
            }
            if (columnIndex == this.d) {
                return downloadableFileSetDescriptionWithUrl.getVersionString();
            }
            if (columnIndex == this.a) {
                return downloadableFileSetDescriptionWithUrl.getUrl();
            }
            return null;
        }

        @Override
        @Nullable
        public String getColumnName(int column) {
            long l3 = f ^ 0x4341F5BE78E3L;
            if (column == this.c) {
                return "Name";
            }
            if (column == this.d) {
                return "Version";
            }
            if (column == this.a) {
                return "URL";
            }
            return "";
        }

        @Nullable
        public DownloadableFileSetDescriptionWithUrl getDescriptionAt(int rowIndex) {
            if (rowIndex < 0 || rowIndex >= this.b.size()) {
                return null;
            }
            return this.b.get(rowIndex);
        }
    }
}

