/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.conditional;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFlipIfIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = element -> element instanceof JSIfStatement && !ErrorUtil.containsError((PsiElement)element) && ((JSIfStatement)element).getCondition() != null;
        if (jSElementPredicate == null) {
            JSFlipIfIntention.$$$reportNull$$$0(0);
        }
        return jSElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        JSIfStatement exp;
        JSExpression condition;
        String negatedText;
        JSExpression replacementExpression;
        if (element == null) {
            JSFlipIfIntention.$$$reportNull$$$0(1);
        }
        JSExpression jSExpression = replacementExpression = StringUtil.isNotEmpty((String)(negatedText = BoolUtils.getNegatedExpressionText(condition = (exp = (JSIfStatement)element).getCondition()))) ? (JSExpression)JSChangeUtil.createExpressionPsiWithContext((String)negatedText, (PsiElement)exp, JSExpression.class) : null;
        if (condition != null && replacementExpression != null) {
            condition.replace(replacementExpression);
        }
        Pair<JSStatement, JSStatement> elementRange = JSFlipIfIntention.processIfStatement(exp);
        FormatFixer.create((PsiElement)((PsiElement)elementRange.getFirst()), (PsiElement)((PsiElement)elementRange.getSecond()), (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat();
    }

    @NotNull
    private static Pair<JSStatement, JSStatement> processIfStatement(@NotNull JSIfStatement original) {
        JSStatement containerStatement;
        JSStatement originalElse;
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(2);
        }
        if ((originalElse = original.getElse()) != null) {
            Pair<JSStatement, JSStatement> pair = JSFlipIfIntention.defaultFlipBranches(original);
            if (pair == null) {
                JSFlipIfIntention.$$$reportNull$$$0(3);
            }
            return pair;
        }
        if (JSFlipIfIntention.alwaysTransfersControlAtEnd(original.getThen())) {
            List<JSStatement> statementsAfter = JSFlipIfIntention.getStatementsAfter((JSStatement)original);
            if (!statementsAfter.isEmpty()) {
                JSStatement first = statementsAfter.get(0);
                PsiElement beforeStatements = first.getPrevSibling();
                if (beforeStatements instanceof PsiWhiteSpace && beforeStatements.textContains('\n')) {
                    beforeStatements.delete();
                }
                original.getParent().deleteChildRange((PsiElement)first, (PsiElement)statementsAfter.get(statementsAfter.size() - 1));
            }
            JSFlipIfIntention.setElseBranch(original, original.getThen());
            JSFlipIfIntention.setThenBranch(original, statementsAfter);
            Pair pair = Pair.create((Object)original, (Object)original);
            if (pair == null) {
                JSFlipIfIntention.$$$reportNull$$$0(4);
            }
            return pair;
        }
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)original, (Class[])new Class[]{JSFunction.class, JSLoopStatement.class, JSSwitchStatement.class});
        JSStatement jSStatement = container instanceof JSFunction ? (JSStatement)ObjectUtils.tryCast((Object)((JSFunction)container).getBody()[0], JSStatement.class) : (containerStatement = container instanceof JSLoopStatement ? ((JSLoopStatement)container).getBody() : null);
        if (container != null && containerStatement instanceof JSBlockStatement && ControlFlowUtils.blockCompletesWithStatement((JSBlockStatement)((JSBlockStatement)containerStatement), (JSStatement)original)) {
            String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)original.getContainingFile());
            String keyword = container instanceof JSFunction ? "return" : "continue";
            JSStatement jumpStatement = (JSStatement)JSChangeUtil.createStatementPsiFromTextWithContext((String)(keyword + semicolon), (PsiElement)original, JSStatement.class);
            JSStatement[] originalThen = JSFlipIfIntention.extractStatements(original.getThen());
            JSStatement lastStatement = JSFlipIfIntention.addStatementsAfter(original, originalThen);
            JSFlipIfIntention.setThenBranch(original, jumpStatement);
            Pair pair = Pair.create((Object)original, (Object)lastStatement);
            if (pair == null) {
                JSFlipIfIntention.$$$reportNull$$$0(5);
            }
            return pair;
        }
        Pair<JSStatement, JSStatement> pair = JSFlipIfIntention.defaultFlipBranches(original);
        if (pair == null) {
            JSFlipIfIntention.$$$reportNull$$$0(6);
        }
        return pair;
    }

    private static JSStatement addStatementsAfter(@NotNull JSIfStatement original, @NotNull JSStatement[] statements) {
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(7);
        }
        if (statements == null) {
            JSFlipIfIntention.$$$reportNull$$$0(8);
        }
        JSIfStatement anchor = original;
        for (JSStatement statement : statements) {
            anchor = anchor.addStatementAfter(statement);
        }
        return anchor;
    }

    private static void setThenBranch(@NotNull JSIfStatement original, @NotNull List<JSStatement> statements) {
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(9);
        }
        if (statements == null) {
            JSFlipIfIntention.$$$reportNull$$$0(10);
        }
        JSFlipIfIntention.setThenBranch(original, JSFlipIfIntention.wrapWithBlockStatement((PsiElement)original, statements));
    }

    private static void setThenBranch(@NotNull JSIfStatement original, @Nullable JSStatement statement) {
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(11);
        }
        original.setThen(statement == null ? null : JSFlipIfIntention.wrapWithBlockStatement((PsiElement)original, statement));
    }

    private static void setElseBranch(@NotNull JSIfStatement original, @Nullable JSStatement statement) {
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(12);
        }
        original.setElse(statement == null ? null : JSFlipIfIntention.wrapWithBlockStatement((PsiElement)original, statement));
    }

    @NotNull
    private static JSStatement wrapWithBlockStatement(@NotNull PsiElement context, @NotNull JSStatement statement) {
        if (context == null) {
            JSFlipIfIntention.$$$reportNull$$$0(13);
        }
        if (statement == null) {
            JSFlipIfIntention.$$$reportNull$$$0(14);
        }
        JSStatement jSStatement = statement instanceof JSBlockStatement ? statement : JSFlipIfIntention.wrapWithBlockStatement(context, ContainerUtil.list((Object[])new JSStatement[]{statement}));
        if (jSStatement == null) {
            JSFlipIfIntention.$$$reportNull$$$0(15);
        }
        return jSStatement;
    }

    @NotNull
    private static JSStatement wrapWithBlockStatement(@NotNull PsiElement context, @NotNull List<JSStatement> statements) {
        if (context == null) {
            JSFlipIfIntention.$$$reportNull$$$0(16);
        }
        if (statements == null) {
            JSFlipIfIntention.$$$reportNull$$$0(17);
        }
        JSBlockStatement blockStatement = (JSBlockStatement)ObjectUtils.assertNotNull((Object)JSChangeUtil.createStatementPsiFromTextWithContext((String)"{}", (PsiElement)context, JSBlockStatement.class));
        PsiElement anchor = ((ASTNode)ObjectUtils.assertNotNull((Object)blockStatement.getNode().findChildByType(JSTokenTypes.LBRACE))).getPsi();
        for (JSStatement toAdd : statements) {
            anchor = blockStatement.addAfter((PsiElement)toAdd, anchor);
        }
        JSBlockStatement jSBlockStatement = blockStatement;
        if (jSBlockStatement == null) {
            JSFlipIfIntention.$$$reportNull$$$0(18);
        }
        return jSBlockStatement;
    }

    private static boolean alwaysTransfersControlAtEnd(@Nullable JSStatement statement) {
        if (statement instanceof JSReturnStatement || statement instanceof JSThrowStatement || statement instanceof JSBreakStatement || statement instanceof JSContinueStatement) {
            return true;
        }
        return statement instanceof JSBlockStatement && JSFlipIfIntention.alwaysTransfersControlAtEnd((JSStatement)ArrayUtil.getLastElement((Object[])((JSBlockStatement)statement).getStatements()));
    }

    @NotNull
    private static List<JSStatement> getStatementsAfter(@NotNull JSStatement original) {
        PsiElement parent;
        List statementsInBlock;
        int originalIndex;
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(19);
        }
        List list = (originalIndex = (statementsInBlock = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)(parent = original.getParent()), JSStatement.class)).indexOf(original)) >= 0 && !statementsInBlock.isEmpty() ? statementsInBlock.subList(originalIndex + 1, statementsInBlock.size()) : statementsInBlock;
        if (list == null) {
            JSFlipIfIntention.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    private static JSStatement[] extractStatements(@NotNull JSStatement statement) {
        JSStatement[] jSStatementArray;
        JSBlockStatement jsBlockStatement;
        if (statement == null) {
            JSFlipIfIntention.$$$reportNull$$$0(21);
        }
        JSBlockStatement jSBlockStatement = jsBlockStatement = statement instanceof JSBlockStatement ? (JSBlockStatement)statement : null;
        if (jsBlockStatement != null) {
            jSStatementArray = jsBlockStatement.getStatements();
        } else {
            JSStatement[] jSStatementArray2 = new JSStatement[1];
            jSStatementArray = jSStatementArray2;
            jSStatementArray2[0] = statement;
        }
        if (jSStatementArray == null) {
            JSFlipIfIntention.$$$reportNull$$$0(22);
        }
        return jSStatementArray;
    }

    @NotNull
    private static Pair<JSStatement, JSStatement> defaultFlipBranches(@NotNull JSIfStatement original) {
        if (original == null) {
            JSFlipIfIntention.$$$reportNull$$$0(23);
        }
        JSStatement elseCopy = original.getElse() != null ? (JSStatement)original.getElse().copy() : null;
        JSStatement thenCopy = original.getThen() != null ? (JSStatement)original.getThen().copy() : null;
        JSFlipIfIntention.setThenBranch(original, elseCopy);
        JSFlipIfIntention.setElseBranch(original, thenCopy);
        Pair pair = Pair.create((Object)original, (Object)original);
        if (pair == null) {
            JSFlipIfIntention.$$$reportNull$$$0(24);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/conditional/JSFlipIfIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 8: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/conditional/JSFlipIfIntention";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "processIfStatement";
                break;
            }
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithBlockStatement";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementsAfter";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "extractStatements";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultFlipBranches";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIfStatement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addStatementsAfter";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setThenBranch";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setElseBranch";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithBlockStatement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStatementsAfter";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "extractStatements";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "defaultFlipBranches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

