/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.Drawable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.jetbrains.annotations.NonNls;

public class DiagramRelationships {
    public static final DiagramRelationshipInfo DEPENDENCY = new DiagramRelationshipInfoAdapter("DEPENDENCY", DiagramLineType.DASHED){

        @Override
        public Shape getStartArrow() {
            return DiagramRelationships.getAngleArrow();
        }
    };
    public static final DiagramRelationshipInfo CREATE = new DiagramRelationshipInfoAdapter("CREATE", DiagramLineType.DASHED, "<html>&laquo;create&raquo;</html>"){

        @Override
        public Shape getStartArrow() {
            return DiagramRelationships.getAngleArrow();
        }
    };
    public static final DiagramRelationshipInfo TO_ONE = new DiagramRelationshipInfoAdapter("TO_ONE", DiagramLineType.SOLID, "1", "1"){

        @Override
        public Shape getStartArrow() {
            return DiagramRelationships.getAngleArrow();
        }

        @Override
        public Shape getEndArrow() {
            return DIAMOND;
        }
    };
    public static final DiagramRelationshipInfo TO_MANY = new DiagramRelationshipInfoAdapter("TO_MANY", DiagramLineType.SOLID, "1", "*"){

        @Override
        public Shape getStartArrow() {
            return DiagramRelationships.getAngleArrow();
        }

        @Override
        public Shape getEndArrow() {
            return DIAMOND;
        }
    };
    public static final DiagramRelationshipInfo GENERALIZATION = new DiagramRelationshipInfoAdapter("GENERALIZATION"){

        @Override
        public Shape getStartArrow() {
            return DELTA;
        }
    };
    public static final DiagramRelationshipInfo INTERFACE_GENERALIZATION = new DiagramRelationshipInfoAdapter("INTERFACE_GENERALIZATION"){

        @Override
        public Shape getStartArrow() {
            return DELTA;
        }
    };
    public static final DiagramRelationshipInfo REALIZATION = new DiagramRelationshipInfoAdapter("REALIZATION", DiagramLineType.DASHED){

        @Override
        public Shape getStartArrow() {
            return DELTA;
        }
    };
    public static final DiagramRelationshipInfo ANNOTATION = new DiagramRelationshipInfoAdapter("ANNOTATION", DiagramLineType.DOTTED){

        @Override
        public Shape getStartArrow() {
            return NONE;
        }
    };
    public static final DiagramRelationshipInfo NOTE = new DiagramRelationshipInfoAdapter("NOTE"){

        @Override
        public Shape getStartArrow() {
            return NONE;
        }
    };
    public static final DiagramRelationshipInfo INNER_CLASS = new DiagramRelationshipInfoAdapter("INNER_CLASS"){
        @NonNls
        private static final String INNER_CLASS_ARROW = "InnerClassArrow";
        private static final int R = 5;

        public Arrow getArrow() {
            if (Arrow.Statics.getCustomArrow((String)INNER_CLASS_ARROW) == null) {
                Drawable arrow = new Drawable(){

                    public void paint(Graphics2D g) {
                        Paint paint = g.getPaint();
                        g.setPaint(g.getBackground());
                        g.fillOval(-10, -5, 10, 10);
                        g.setPaint(paint);
                        g.drawOval(-10, -5, 10, 10);
                        g.drawLine(-5, -3, -5, 3);
                        g.drawLine(-8, 0, -2, 0);
                    }

                    public Rectangle getBounds() {
                        return new Rectangle(-5, -5, 5, 5);
                    }
                };
                Arrow.Statics.addCustomArrow((String)INNER_CLASS_ARROW, (Drawable)arrow);
            }
            return Arrow.Statics.getCustomArrow((String)INNER_CLASS_ARROW);
        }

        @Override
        public Shape getStartArrow() {
            return this.getArrow().getShape();
        }
    };

    private DiagramRelationships() {
    }

    public static Shape getAngleArrow() {
        GeneralPath shape = new GeneralPath();
        shape.moveTo(-8.0f, -5.0f);
        shape.lineTo(0.0f, 0.0f);
        shape.lineTo(-8.0f, 5.0f);
        return shape;
    }
}

