/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.TableUtil;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.TableModel;
import org.zmlx.hg4idea.ui.MultiReorderedModel;

public class TableRowsTransferHandler
extends TransferHandler {
    private static final Logger LOG = Logger.getInstance(TableRowsTransferHandler.class);
    private final DataFlavor myDataFlavor = new ActivationDataFlavor(RowsDragInfo.class, DataFlavor.stringFlavor.getMimeType());
    private final JTable myTable;

    public TableRowsTransferHandler(JTable table) {
        this.myTable = table;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        assert (c == this.myTable);
        return new DataHandler((Object)new RowsDragInfo(this.myTable.getSelectedRows()), this.myDataFlavor.getMimeType());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean canImport = support.getComponent() == this.myTable && support.isDrop();
        this.myTable.setCursor(canImport ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
        return canImport;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        TableModel tableModel = this.myTable.getModel();
        if (!(tableModel instanceof MultiReorderedModel) || !((MultiReorderedModel)((Object)tableModel)).canMoveRows()) {
            return false;
        }
        JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
        int index = dl.getRow();
        int max = tableModel.getRowCount();
        if (index < 0 || index > max) {
            index = max;
        }
        this.myTable.setCursor(Cursor.getPredefinedCursor(0));
        try {
            int[] rows = ((RowsDragInfo)support.getTransferable().getTransferData((DataFlavor)this.myDataFlavor)).myRows;
            if (rows != null && rows.length > 0) {
                int dist = 0;
                for (int row : rows) {
                    if (index <= row) continue;
                    ++dist;
                }
                int[] newSelection = ((MultiReorderedModel)((Object)tableModel)).moveRows(rows, index -= dist);
                TableUtil.selectRows((JTable)this.myTable, (int[])newSelection);
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't move transferred data.");
        }
        return false;
    }

    private static class RowsDragInfo {
        final int[] myRows;

        RowsDragInfo(int[] rows) {
            this.myRows = rows;
        }
    }
}

