/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.BoolUtils;
import com.sixrr.inspectjs.utils.ConditionalUtils;
import org.jetbrains.annotations.NotNull;

public class TrivialConditionalJSInspection
extends JavaScriptInspection {
    private static final TrivialConditionalFix TRIVIAL_CONDITIONAL_FIX = new TrivialConditionalFix();

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("redundant.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            TrivialConditionalJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            TrivialConditionalJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConditionalExpressionVisitor();
    }

    @Override
    public String buildErrorString(Object ... args) {
        JSConditionalExpression exp = (JSConditionalExpression)args[0];
        return InspectionJSBundle.message("trivial.conditional.error.string", exp.getText(), TrivialConditionalJSInspection.calculateReplacementExpression(exp));
    }

    private static String calculateReplacementExpression(JSConditionalExpression exp) {
        JSExpression thenExpression = exp.getThen();
        JSExpression elseExpression = exp.getElse();
        JSExpression condition = exp.getCondition();
        if (condition == null) {
            return exp.getText();
        }
        if (TrivialConditionalJSInspection.isFalse(thenExpression) && TrivialConditionalJSInspection.isTrue(elseExpression)) {
            return BoolUtils.getNegatedExpressionText(condition);
        }
        return ConditionalUtils.castToBoolean(condition);
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return TRIVIAL_CONDITIONAL_FIX;
    }

    private static boolean isTrue(JSExpression expression) {
        return expression instanceof JSLiteralExpression && ((JSLiteralExpression)expression).isBooleanLiteral() && Boolean.TRUE.equals(((JSLiteralExpression)expression).getValue());
    }

    private static boolean isFalse(JSExpression expression) {
        return expression instanceof JSLiteralExpression && ((JSLiteralExpression)expression).isBooleanLiteral() && Boolean.FALSE.equals(((JSLiteralExpression)expression).getValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/control/TrivialConditionalJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConditionalExpressionVisitor() {
        }

        public void visitJSConditionalExpression(JSConditionalExpression exp) {
            super.visitJSConditionalExpression(exp);
            JSExpression condition = exp.getCondition();
            if (condition == null) {
                return;
            }
            JSExpression thenExpression = exp.getThen();
            if (thenExpression == null) {
                return;
            }
            JSExpression elseExpression = exp.getElse();
            if (elseExpression == null) {
                return;
            }
            if (TrivialConditionalJSInspection.isFalse(thenExpression) && TrivialConditionalJSInspection.isTrue(elseExpression) || TrivialConditionalJSInspection.isTrue(thenExpression) && TrivialConditionalJSInspection.isFalse(elseExpression)) {
                this.registerError((PsiElement)exp);
            }
        }
    }

    private static class TrivialConditionalFix
    extends InspectionJSFix {
        private TrivialConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("simplify.fix", new Object[0]);
            if (string == null) {
                TrivialConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            JSConditionalExpression expression = (JSConditionalExpression)descriptor2.getPsiElement();
            String newExpression = TrivialConditionalJSInspection.calculateReplacementExpression(expression);
            TrivialConditionalFix.replaceExpression((JSExpression)expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TrivialConditionalJSInspection$TrivialConditionalFix", "getFamilyName"));
        }
    }
}

