/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.ByteFlagsSerializer;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImplicitParameterStructure {
    public static final JSImplicitParameterStructure[] EMPTY_ARRAY = new JSImplicitParameterStructure[0];
    private static final BooleanStructureElement OPTIONAL_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement EXPLICITLY_DECLARED_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement REST_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPE_FLAG = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(OPTIONAL_FLAG, EXPLICITLY_DECLARED_FLAG, REST_FLAG, HAS_TYPE_FLAG);
    private static final String NULL_SERIALIZED_NAME = "^null";
    @Nullable
    private final String myName;
    @Nullable
    private final String myTypeString;
    private final byte myFlags;

    public JSImplicitParameterStructure(@Nullable String name, @Nullable String jsdocTypeString, byte flags) {
        this.myName = name;
        this.myTypeString = jsdocTypeString;
        this.myFlags = flags;
    }

    public JSImplicitParameterStructure(@Nullable String name, @Nullable String typeString, boolean isOptional, boolean isRest, boolean isTypeExplicitlyDeclared) {
        this.myName = name;
        this.myTypeString = typeString;
        this.myFlags = JSImplicitParameterStructure.calcFlags(isOptional, isRest, isTypeExplicitlyDeclared, typeString);
    }

    private static byte calcFlags(boolean isOptional, boolean isRest, boolean isTypeExplicitlyDeclared, String typeString) {
        byte flags = 0;
        flags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, HAS_TYPE_FLAG, typeString != null, flags);
        flags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, OPTIONAL_FLAG, isOptional, flags);
        flags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, EXPLICITLY_DECLARED_FLAG, isTypeExplicitlyDeclared, flags);
        flags = ByteFlagsSerializer.INSTANCE.writeValue(FLAGS_STRUCTURE, REST_FLAG, isRest, flags);
        return flags;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getTypeString() {
        return this.myTypeString;
    }

    public boolean isOptional() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, OPTIONAL_FLAG, this.myFlags);
    }

    public boolean isRest() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, REST_FLAG, this.myFlags);
    }

    public boolean isTypeExplicitlyDeclared() {
        return ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, EXPLICITLY_DECLARED_FLAG, this.myFlags);
    }

    void serialize(@NotNull DataOutput dataStream) throws IOException {
        if (dataStream == null) {
            JSImplicitParameterStructure.$$$reportNull$$$0(0);
        }
        IOUtil.writeUTF((DataOutput)dataStream, (String)(this.myName != null ? this.myName : NULL_SERIALIZED_NAME));
        dataStream.writeByte(this.myFlags);
        assert (ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_TYPE_FLAG, this.myFlags) == (this.myTypeString != null));
        if (this.myTypeString != null) {
            IOUtil.writeUTF((DataOutput)dataStream, (String)this.myTypeString);
        }
    }

    @NotNull
    static JSImplicitParameterStructure deserialize(@NotNull DataInput dataStream) throws IOException {
        String name;
        if (dataStream == null) {
            JSImplicitParameterStructure.$$$reportNull$$$0(1);
        }
        if (NULL_SERIALIZED_NAME.equals(name = IOUtil.readUTF((DataInput)dataStream))) {
            name = null;
        }
        byte flags = dataStream.readByte();
        boolean notNullType = ByteFlagsSerializer.INSTANCE.readValue(FLAGS_STRUCTURE, HAS_TYPE_FLAG, flags);
        String typeString = null;
        if (notNullType) {
            typeString = IOUtil.readUTF((DataInput)dataStream);
        }
        JSImplicitParameterStructure jSImplicitParameterStructure = new JSImplicitParameterStructure(name, typeString, flags);
        if (jSImplicitParameterStructure == null) {
            JSImplicitParameterStructure.$$$reportNull$$$0(2);
        }
        return jSImplicitParameterStructure;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JSImplicitParameterStructure)) {
            return false;
        }
        JSImplicitParameterStructure other = (JSImplicitParameterStructure)obj;
        return StringUtil.equals((CharSequence)this.myName, (CharSequence)other.myName) && this.myFlags == other.myFlags;
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitParameterStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSImplicitParameterStructure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

