/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBaseTypesIndex
extends StringStubIndexExtension<JSElement> {
    public static final StubIndexKey<String, JSElement> KEY = StubIndexKey.createIndexKey((String)"JS.base.types.index");
    private static final String STATIC_SUFFIX = "\u0001s";
    private static final int VERSION = 1;

    @NotNull
    public StubIndexKey<String, JSElement> getKey() {
        StubIndexKey<String, JSElement> stubIndexKey = KEY;
        if (stubIndexKey == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(0);
        }
        return stubIndexKey;
    }

    public int getVersion() {
        return super.getVersion() + 1;
    }

    @NotNull
    public static String getTextForProcessingHierarchy(@NotNull String typeString) {
        JSType jsType;
        if (typeString == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(1);
        }
        if ((jsType = JSTypeUtils.createType(typeString, JSTypeSource.EMPTY_TS)) == null) {
            String string = typeString;
            if (string == null) {
                JSBaseTypesIndex.$$$reportNull$$$0(2);
            }
            return string;
        }
        JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(jsType, false);
        if (namespace == null) {
            String string = typeString;
            if (string == null) {
                JSBaseTypesIndex.$$$reportNull$$$0(3);
            }
            return string;
        }
        JSQualifiedName qualifiedName = namespace.getQualifiedName();
        String string = qualifiedName != null ? qualifiedName.getQualifiedName() : typeString;
        if (string == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getTextForProcessingHierarchy(@NotNull JSQualifiedName qualifiedName, @NotNull JSContext jsContext) {
        if (qualifiedName == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(5);
        }
        if (jsContext == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(6);
        }
        String text = qualifiedName.getQualifiedName();
        if (jsContext == JSContext.STATIC) {
            text = text + STATIC_SUFFIX;
        }
        String string = text;
        if (string == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getTextForProcessingHierarchy(@NotNull JSType type) {
        if (type == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(8);
        }
        String text = type.getTypeText(JSType.TypeTextFormat.SIMPLE);
        if (type instanceof JSNamespace && ((JSNamespace)type).getJSContext() == JSContext.STATIC) {
            text = text + STATIC_SUFFIX;
        }
        String string = text;
        if (string == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public static JSNamespace deserializeHierarchyElement(@NotNull String serializedNamespace, boolean isStrict) {
        JSType type;
        if (serializedNamespace == null) {
            JSBaseTypesIndex.$$$reportNull$$$0(10);
        }
        JSContext jsContext = JSContext.INSTANCE;
        if (serializedNamespace.endsWith(STATIC_SUFFIX)) {
            jsContext = JSContext.STATIC;
            serializedNamespace = serializedNamespace.substring(0, serializedNamespace.length() - STATIC_SUFFIX.length());
        }
        if ((type = JSTypeUtils.createType(serializedNamespace, isStrict ? JSTypeSource.EXPLICITLY_DECLARED : JSTypeSource.EMPTY)) instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        if (!(type instanceof JSNamedType)) {
            return null;
        }
        return jsContext == JSContext.STATIC ? JSNamedTypeFactory.copyWithJSContext((JSNamespace)type, jsContext) : (JSNamespace)type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/JSBaseTypesIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializedNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/JSBaseTypesIndex";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextForProcessingHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTextForProcessingHierarchy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserializeHierarchyElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

