/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSStubElementImpl<T extends JSStubElement<?>>
extends StubBasedPsiElementBase<T>
implements JSElement {
    @NonNls
    private static final String IMPL = "Impl";
    private Language myLanguage;

    public JSStubElementImpl(ASTNode node) {
        super(node);
    }

    public JSStubElementImpl(T t, IStubElementType type) {
        super(t, type);
    }

    @NotNull
    public Language getLanguage() {
        if (this.myLanguage == null) {
            this.myLanguage = DialectDetector.calculateJSLanguage((PsiElement)this);
        }
        Language language = this.myLanguage;
        if (language == null) {
            JSStubElementImpl.$$$reportNull$$$0(0);
        }
        return language;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSStubElementImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSElement((JSElement)this);
        } else {
            super.accept(visitor);
        }
    }

    @NotNull
    public final SearchScope getDefaultUseScope() {
        PsiFile file2 = this.getContainingFile();
        SearchScope searchScope = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2).getUseScope();
        if (searchScope == null) {
            JSStubElementImpl.$$$reportNull$$$0(2);
        }
        return searchScope;
    }

    public String toString() {
        String classname = ((Object)((Object)this)).getClass().getName();
        classname = StringUtil.trimEnd((String)classname, (String)IMPL);
        classname = classname.substring(classname.lastIndexOf(".") + 1);
        if (!ApplicationManager.getApplication().isUnitTestMode() && this instanceof JSNamedElement) {
            classname = classname + ":";
            String name = this.getName();
            classname = classname + (name != null ? name : JSFormatUtil.ANONYMOUS_ELEMENT_PRESENTATION);
        }
        return classname;
    }

    public ItemPresentation getPresentation() {
        if (this instanceof JSPsiElementBase) {
            return new JSItemPresentation((JSPsiElementBase)this);
        }
        return null;
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSStubElementImpl.$$$reportNull$$$0(3);
        }
        if (JSChangeUtil.isSourceElementOrComment(element)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddBefore((PsiElement)this, element, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddBefore(element, anchor);
            }
        }
        return super.addBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSStubElementImpl.$$$reportNull$$$0(4);
        }
        if (JSChangeUtil.isSourceElementOrComment(element)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddAfter((PsiElement)this, element, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddAfter(element, anchor);
            }
        }
        return super.addAfter(element, anchor);
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            JSStubElementImpl.$$$reportNull$$$0(5);
        }
        if (last == null) {
            JSStubElementImpl.$$$reportNull$$$0(6);
        }
        if (JSChangeUtil.isSourceElementOrComment(first)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return (PsiElement)JSChangeUtil.doAddRangeBefore((PsiElement)this, (PsiElement)first, (PsiElement)last, (PsiElement)anchor).first;
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddRangeBefore(first, last, anchor);
            }
        }
        return super.addRangeBefore(first, last, anchor);
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (JSChangeUtil.isSourceElementOrComment(first)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return (PsiElement)JSChangeUtil.doAddRangeAfter((PsiElement)this, (PsiElement)first, (PsiElement)last, (PsiElement)anchor).first;
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddRangeAfter(first, last, anchor);
            }
        }
        return super.addRangeAfter(first, last, anchor);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSStubElementImpl.$$$reportNull$$$0(7);
        }
        return this.addAfter(element, null);
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        return this.addRangeAfter(first, last, null);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            JSStubElementImpl.$$$reportNull$$$0(8);
        }
        ASTNode myNode = this.getNode();
        ASTNode result2 = newElement.getNode().copyElement();
        myNode.getTreeParent().replaceChild(myNode, result2);
        return result2.getPsi();
    }

    @NotNull
    protected static Icon getIcon(@NotNull JSPsiElementBase element, @NotNull Icon defaultBaseIcon, int flags) {
        if (element == null) {
            JSStubElementImpl.$$$reportNull$$$0(9);
        }
        if (defaultBaseIcon == null) {
            JSStubElementImpl.$$$reportNull$$$0(10);
        }
        Icon icon = defaultBaseIcon;
        JSDocComment docComment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element);
        if (docComment != null && docComment.isClassExplicitly()) {
            icon = JSIconProvider.DEFAULT_INSTANCE.getClassIcon();
        }
        boolean blendStatic = element.getJSContext() == JSContext.STATIC;
        boolean blendFinal = false;
        if (element instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
            boolean bl = blendFinal = attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL);
        }
        if (element instanceof JSVariable && ((JSVariable)element).isConst() || element instanceof JSField && ((JSField)element).isConst()) {
            blendFinal = true;
        }
        icon = JSStubElementImpl.blendFlags(icon, blendStatic, blendFinal);
        JSVisibilityUtil.PresentableAccessModifier accessType = JSVisibilityUtil.getPresentableAccessModifier((JSElement)element);
        if (accessType != null) {
            icon = JSStubElementImpl.iconWithVisibilityIfNeeded((int)flags, (Icon)icon, (Icon)accessType.getIcon());
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            JSStubElementImpl.$$$reportNull$$$0(11);
        }
        return icon2;
    }

    protected static Icon blendModifierFlags(Icon baseIcon, JSAttributeList attrList, boolean blendStatic) {
        PsiElement superParent;
        PsiElement grandParent;
        if (attrList == null) {
            return baseIcon;
        }
        boolean isStatic = attrList.hasModifier(JSAttributeList.ModifierType.STATIC) || (grandParent = attrList.getParent().getParent()) instanceof JSBlockStatement && ((superParent = grandParent.getParent()) instanceof JSClass || superParent instanceof JSFile && superParent.getContext() != null);
        return JSStubElementImpl.blendFlags(baseIcon, blendStatic && isStatic || attrList.hasModifier(JSAttributeList.ModifierType.DYNAMIC), attrList.hasModifier(JSAttributeList.ModifierType.FINAL));
    }

    public static Icon blendFlags(Icon baseIcon, boolean blendStatic, boolean blendFinal) {
        if (blendStatic) {
            baseIcon = ElementBase.overlayIcons((Icon[])new Icon[]{baseIcon, AllIcons.Nodes.StaticMark});
        }
        if (blendFinal) {
            baseIcon = ElementBase.overlayIcons((Icon[])new Icon[]{baseIcon, AllIcons.Nodes.FinalMark});
        }
        return baseIcon;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = JSResolveUtil.getResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            JSStubElementImpl.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.clearCaches();
    }

    public void clearCaches() {
        if (JSControlFlowService.isControlFlowScope((PsiElement)this)) {
            JSControlFlowService.getService(this.getProject()).resetFlow(this);
        }
    }

    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        if (this instanceof JSQualifiedNamedElement) {
            JSStubElement stub = (JSStubElement)this.getGreenStub();
            if (stub instanceof JSQualifiedObjectStubBase) {
                JSElementBase.ClassOrInterface classOrInterface = ((JSQualifiedObjectStubBase)stub).isClassOrInterface();
                if (classOrInterface == null) {
                    JSStubElementImpl.$$$reportNull$$$0(13);
                }
                return classOrInterface;
            }
            JSElementBase.ClassOrInterface classOrInterface = JSDocumentationUtils.isClassOrInterface((JSQualifiedNamedElement)this);
            if (classOrInterface == null) {
                JSStubElementImpl.$$$reportNull$$$0(14);
            }
            return classOrInterface;
        }
        JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.NONE;
        if (classOrInterface == null) {
            JSStubElementImpl.$$$reportNull$$$0(15);
        }
        return classOrInterface;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSStubElementImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultBaseIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSStubElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUseScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRangeBefore";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

