/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSSwapMethodCallArgumentsIntention
extends JavaScriptIntention {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSSwapMethodCallArgumentsIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSSwapMethodCallArgumentsIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        if (!(element instanceof JSArgumentList)) {
            element = element.getParent();
        }
        if (!(element instanceof JSArgumentList)) {
            return false;
        }
        JSExpression[] arguments = ((JSArgumentList)element).getArguments();
        if (arguments.length != 2) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof JSCallExpression)) {
            return false;
        }
        JSExpression methodExpression = ((JSCallExpression)parent).getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement psiElement = ((JSReferenceExpression)methodExpression).resolve();
        if (!(psiElement instanceof JSFunction)) {
            return false;
        }
        JSParameterList parameterList = ((JSFunction)psiElement).getParameterList();
        if (parameterList == null) {
            return false;
        }
        JSParameterListElement[] parameters = parameterList.getParameters();
        if (parameters.length != 2) {
            return false;
        }
        JSType type1 = parameters[0].getType();
        JSType type2 = parameters[1].getType();
        if (type1 == null ? type2 != null : !type1.isEquivalentTo(type2, null)) {
            return false;
        }
        this.setText(JSBundle.message((String)"js.swap.$0.and.$1", (Object[])new Object[]{StringUtil.first((String)arguments[0].getText(), (int)20, (boolean)true), StringUtil.first((String)arguments[1].getText(), (int)20, (boolean)true)}));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSSwapMethodCallArgumentsIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSSwapMethodCallArgumentsIntention.$$$reportNull$$$0(3);
        }
        if (!(element instanceof JSArgumentList)) {
            element = element.getParent();
        }
        JSArgumentList argumentList = (JSArgumentList)element;
        JSExpression[] arguments = argumentList.getArguments();
        JSCallExpression expression = JSChangeUtil.createExpressionPsiWithContext("f(" + arguments[1].getText() + ", " + arguments[0].getText() + ");", (PsiElement)argumentList, JSCallExpression.class);
        JSArgumentList newArgumentList = expression.getArgumentList();
        argumentList.replace((PsiElement)newArgumentList);
    }

    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.swap.arguments", (Object[])new Object[0]);
        if (string == null) {
            JSSwapMethodCallArgumentsIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSSwapMethodCallArgumentsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSSwapMethodCallArgumentsIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

