/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupElementInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.generation.TypeScriptImplementMembersHandler;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitPrototypeElement;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLookupUtilImpl {
    private static final JSLookupPriority MY_LAST_VALUE_WITHOUT_PRIORITY = JSLookupPriority.RELEVANT_SMARTNESS_PRIORITY;
    @NotNull
    private static final InsertHandler<LookupElement> PARAM_LIST_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            int startOffset = context.getTailOffset();
            int endOffset = CharArrayUtil.shiftForwardUntil((CharSequence)context.getDocument().getImmutableCharSequence(), (int)startOffset, (String)")");
            context.getDocument().deleteString(startOffset, endOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/completion/JSLookupUtilImpl$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public static LookupElement createMultiparamCompletionItem(PsiElement element, String lookupString) {
        LookupElementBuilder lookupElementBuilder = (element == null ? LookupElementBuilder.create((String)lookupString) : LookupElementBuilder.create((Object)element, (String)lookupString)).withIcon(IconHolder.ourParamParamIcon).withInsertHandler(PARAM_LIST_INSERT_HANDLER);
        if (lookupElementBuilder == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(0);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static Couple<String> getTypeAndTailTexts(@NotNull PsiElement element, @Nullable JSTypeSubstitutor typeSubstitutor) {
        String packageLocationString;
        String s;
        JSType type;
        JSFunctionItem original;
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(1);
        }
        String typeText = null;
        String tailText = null;
        JSFunctionItem possibleFunction = JSPsiImplUtils.calculatePossibleFunction(element, null, false);
        if (possibleFunction != null && possibleFunction.isValid() && (original = (JSFunctionItem)CompletionUtil.getOriginalElement((PsiElement)possibleFunction)) != null) {
            possibleFunction = original;
        }
        if (possibleFunction != null && possibleFunction.isValid()) {
            JSType typeFromSetAccessor;
            type = possibleFunction.getReturnType();
            if (type instanceof JSVoidType && possibleFunction.isSetProperty() && (typeFromSetAccessor = JSResolveUtil.getTypeFromSetAccessor(possibleFunction)) != null) {
                type = typeFromSetAccessor;
            }
            if (JSLookupUtilImpl.isTypeAcceptableForHint(type)) {
                type = JSTypeUtils.applyGenericArguments(type, typeSubstitutor);
                typeText = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            }
        } else if (element instanceof JSClass || element instanceof JSNamespaceDeclaration) {
            if (DialectDetector.isActionScript(element)) {
                typeText = JSItemPresentation.getFileName(element.getContainingFile());
            } else {
                tailText = JSLookupUtilImpl.getLocationStringFromPresentation((NavigationItem)element);
            }
        } else {
            type = JSTypeUtils.getTypeOfElement(element);
            if (JSLookupUtilImpl.isTypeAcceptableForHint(type)) {
                type = JSTypeUtils.applyGenericArguments(type, typeSubstitutor);
                typeText = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            }
        }
        if (possibleFunction != null && possibleFunction.isValid() && (s = JSLookupUtilImpl.getFunctionTailText(possibleFunction, true, typeSubstitutor)) != null) {
            tailText = s;
        }
        if (element instanceof JSQualifiedNamedElement && tailText == null && (packageLocationString = JSLookupUtilImpl.getPackageLocationString((JSElementBase)((JSQualifiedNamedElement)element))) != null) {
            tailText = packageLocationString;
        }
        if (tailText == null) {
            tailText = JSLookupUtilImpl.getLocationStringFromPresentation((NavigationItem)element);
        }
        Couple couple = Couple.of((Object)typeText, (Object)tailText);
        if (couple == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(2);
        }
        return couple;
    }

    private static boolean isTypeAcceptableForHint(@Nullable JSType type) {
        return type != null && !JSTypeUtils.hasTypes(type, JSEvaluableType.class) && !(type instanceof JSRecordType);
    }

    private static boolean isPredefined(PsiElement element) {
        PsiFile containingFile = element != null ? element.getContainingFile() : null;
        return containingFile != null && JSResolveUtil.isFromPredefinedFile(containingFile);
    }

    @Nullable
    private static String getPackageLocationString(@NotNull JSElementBase elt) {
        JSQualifiedName namespace;
        PsiElement parent;
        if (elt == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = parent = elt instanceof JSQualifiedNamedElement ? JSResolveUtil.findParent((PsiElement)((JSQualifiedNamedElement)elt)) : null;
        if ((parent instanceof JSPackageStatement || parent instanceof JSFile || elt instanceof XmlBackedJSClass || elt.isNamespaceExplicitlyDeclared()) && (namespace = elt.getNamespace()) != null) {
            return " (" + namespace.getQualifiedName() + ")";
        }
        if (parent instanceof JSFile) {
            return JSLookupUtilImpl.getLocationStringFromPresentation((NavigationItem)((JSQualifiedNamedElement)elt));
        }
        return null;
    }

    public static Icon getIcon(PsiElement element, boolean ecma) {
        Icon browserIcon;
        Icon originalIcon;
        Icon icon = element instanceof JSElement ? element.getIcon(1) : (element instanceof XmlElement ? JSIconProvider.HTML_TAG_ICON : (originalIcon = element instanceof CssClass ? element.getIcon(1) : JSLookupUtilImpl.getEmptyIcon()));
        if (ecma) {
            return originalIcon;
        }
        if (!(originalIcon instanceof RowIcon)) {
            Icon browserIcon2 = JSLookupUtilImpl.getBrowserIcon(element);
            if (browserIcon2 == JSLookupUtilImpl.getEmptyIcon()) {
                return originalIcon;
            }
            RowIcon newIcon = new RowIcon(2);
            newIcon.setIcon(originalIcon, 0);
            newIcon.setIcon(browserIcon2, 1);
            return newIcon;
        }
        RowIcon newIcon = (RowIcon)originalIcon;
        if (newIcon.getIconCount() > 1 && (browserIcon = JSLookupUtilImpl.getBrowserIcon(element)) != JSLookupUtilImpl.getEmptyIcon()) {
            newIcon.setIcon(browserIcon, 1);
        }
        return newIcon;
    }

    @NotNull
    public static Icon getBrowserIcon(PsiElement element) {
        JSDocComment docComment;
        if (JSLookupUtilImpl.isPredefined(element) && (docComment = JSStubBasedPsiTreeUtil.findDocComment(element)) != null) {
            JSDocComment.BrowserFamily browserFamily = docComment.getBrowserFamily();
            switch (browserFamily) {
                case GECKO: {
                    Icon icon = AllIcons.Xml.Browsers.Firefox16;
                    if (icon == null) {
                        JSLookupUtilImpl.$$$reportNull$$$0(4);
                    }
                    return icon;
                }
                case IE: {
                    Icon icon = AllIcons.Xml.Browsers.Explorer16;
                    if (icon == null) {
                        JSLookupUtilImpl.$$$reportNull$$$0(5);
                    }
                    return icon;
                }
                case OPERA: {
                    Icon icon = AllIcons.Xml.Browsers.Opera16;
                    if (icon == null) {
                        JSLookupUtilImpl.$$$reportNull$$$0(6);
                    }
                    return icon;
                }
            }
        }
        Icon icon = JSLookupUtilImpl.getEmptyIcon();
        if (icon == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(7);
        }
        return icon;
    }

    @Nullable
    public static String getFunctionTailText(JSFunctionItem function, boolean withLocation, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (!function.isGetProperty() && !function.isSetProperty()) {
            String packageLocationString;
            JSParameterItem[] parameters;
            StringBuilder result2 = new StringBuilder();
            result2.append("(");
            for (JSParameterItem parameter : parameters = function.getParameters()) {
                if (result2.length() > 1) {
                    result2.append(", ");
                }
                result2.append(JSParameterInfoHandler.getSignatureForParameter(parameter, typeSubstitutor));
            }
            result2.append(")");
            if (withLocation && (packageLocationString = JSLookupUtilImpl.getPackageLocationString((JSElementBase)function)) != null) {
                result2.append(packageLocationString);
            }
            return result2.toString();
        }
        return null;
    }

    private static String getLocationStringFromPresentation(NavigationItem item) {
        String locationString;
        ItemPresentation presentation = item.getPresentation();
        if (presentation != null && (locationString = presentation.getLocationString()) != null) {
            return " " + locationString;
        }
        return "";
    }

    public static boolean willCreateLookupElement(@NotNull JSLookupPriority priority) {
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(8);
        }
        return priority.compareTo(MY_LAST_VALUE_WITHOUT_PRIORITY) > 0 || !JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction();
    }

    public static String getShortName(String qName) {
        JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(qName);
        String textToRender = signature != null ? "Vector.<" + JSLookupUtilImpl.getShortName(signature.genericType) + ">" : (!StringUtil.containsAnyChar((String)qName, (String)"<[(={") ? qName.substring(qName.lastIndexOf(46) + 1) : qName);
        return textToRender;
    }

    @NotNull
    public static LookupElementBuilder createLookupElement(@NotNull PsiNamedElement element) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(9);
        }
        LookupElementBuilder lookupElementBuilder = JSLookupUtilImpl.createLookupElement((PsiElement)element, StringUtil.notNullize((String)element.getName()));
        if (lookupElementBuilder == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(10);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static LookupElementBuilder createLookupElement(@NotNull PsiElement element, String name) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(11);
        }
        Couple<String> typeAndTail = JSLookupUtilImpl.getTypeAndTailTexts(element, null);
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)element, (String)name).withIcon(JSLookupUtilImpl.getIcon(element, false)).withTypeText((String)typeAndTail.first).withStrikeoutness(JSDocumentationUtils.isDeprecated(element)).withBoldness(true).withTailText((String)typeAndTail.second, false);
        if (lookupElementBuilder == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(12);
        }
        return lookupElementBuilder;
    }

    @NotNull
    public static LookupElement createPrioritizedLookupElement(@NotNull PsiNamedElement element, @NotNull JSLookupPriority priority) {
        if (element == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(13);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(14);
        }
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)JSLookupUtilImpl.createLookupElement(element), (double)priority.getPriorityValue());
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(15);
        }
        return lookupElement;
    }

    public static LookupElement toBoldLookupElement(@NotNull Object lookupElement) {
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(16);
        }
        if (lookupElement instanceof LookupElement) {
            return JSLookupUtilImpl.setBold((LookupElement)lookupElement, true);
        }
        return LookupElementBuilder.create((String)lookupElement.toString()).bold();
    }

    @Contract(value="null, _ -> true; _, null -> true")
    public static boolean matchElementWithContext(@Nullable PsiElement element, @Nullable PsiElement place) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.PRIVATE_SHARP_SYNTAX)) {
            return true;
        }
        boolean isSharpContext = JSUtils.isPrivateFieldSharpAccessContext(place);
        return !isSharpContext || JSUtils.isPrivateSharpItem(element);
    }

    @NotNull
    public static LookupElement createLookupItemForStaticCall(@NotNull JSElement methodElement, @NotNull JSElement ownerElement) {
        if (methodElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(17);
        }
        if (ownerElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(18);
        }
        LookupElementBuilder builder = JSLookupUtilImpl.createLookupElement((PsiElement)methodElement, ownerElement.getName() + "." + methodElement.getName());
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder.withInsertHandler((c, i) -> {
            JSInsertHandler.insertBracesIfNeed(c, 1);
            new ShowParameterInfoHandler().invoke(c.getProject(), c.getEditor(), c.getFile());
        }), (double)JSLookupPriority.SMART_PRIORITY.getPriorityValue());
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(19);
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement createImplementAbstractOrInterfaceLookupItem(@NotNull PsiElement namedElement, @NotNull String className) {
        if (namedElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(20);
        }
        if (className == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(21);
        }
        String extendsWord = namedElement instanceof JSClass && ((JSClass)namedElement).isInterface() ? "implements" : "extends";
        LookupElementBuilder builder = JSLookupUtilImpl.createLookupElement(namedElement, "class " + extendsWord + " " + className + " {}");
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)builder.withLookupString(className).withPresentableText(className + "{...}").withInsertHandler((c, i) -> JSLookupUtilImpl.generateMissingMembersForItem(c)), (double)JSLookupPriority.SMART_PRIORITY.getPriorityValue());
        if (lookupElement == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(22);
        }
        return lookupElement;
    }

    private static void generateMissingMembersForItem(@NotNull InsertionContext c) {
        if (c == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(23);
        }
        Editor editor = c.getEditor();
        int startOffset = c.getStartOffset();
        editor.getCaretModel().moveToOffset(startOffset);
        PsiElement element = c.getFile().findElementAt(startOffset);
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
        assert (jsClass != null);
        TypeScriptImplementMembersHandler handler = new TypeScriptImplementMembersHandler();
        handler.setSkipMemberChooserDialog(true);
        handler.invoke(c.getProject(), editor, c.getFile());
        editor.getCaretModel().moveToOffset(jsClass.getTextRange().getEndOffset());
    }

    public static boolean isBold(@Nullable LookupElement element) {
        if (element instanceof PrioritizedLookupElement) {
            element = ((PrioritizedLookupElement)element).getDelegate();
        }
        if (element instanceof LookupElementBuilder) {
            BoldCheckingLookupElementPresentation presentation = new BoldCheckingLookupElementPresentation();
            element.renderElement((LookupElementPresentation)presentation);
            return presentation.isItemTextBold();
        }
        return false;
    }

    @Nullable
    @Contract(value="null,_ -> null; !null,_ -> !null")
    public static LookupElement setBold(@Nullable LookupElement lookupElement, boolean boldness) {
        LookupElement actualElement = lookupElement;
        if (lookupElement instanceof PrioritizedLookupElement) {
            lookupElement = ((PrioritizedLookupElement)lookupElement).getDelegate();
        }
        if (lookupElement instanceof LookupElementBuilder) {
            BoldCheckingLookupElementPresentation presentation = new BoldCheckingLookupElementPresentation();
            lookupElement.renderElement((LookupElementPresentation)presentation);
            if (presentation.isItemTextBold() == boldness) {
                return actualElement;
            }
            LookupElementRenderer renderer = presentation.myRenderer;
            LookupElementBuilder newElement = !(renderer instanceof IBoldnessProvidingLookupElementRenderer) ? ((LookupElementBuilder)lookupElement).withBoldness(boldness) : ((LookupElementBuilder)lookupElement).withRenderer(((IBoldnessProvidingLookupElementRenderer)renderer).copyWithBoldness(boldness));
            return actualElement instanceof PrioritizedLookupElement ? PrioritizedLookupElement.withExplicitProximity((LookupElement)PrioritizedLookupElement.withGrouping((LookupElement)PrioritizedLookupElement.withPriority((LookupElement)newElement, (double)((PrioritizedLookupElement)actualElement).getPriority()), (int)((PrioritizedLookupElement)actualElement).getGrouping()), (int)((PrioritizedLookupElement)actualElement).getExplicitProximity()) : newElement;
        }
        return actualElement;
    }

    public static void setForceQualify(@Nullable LookupElement lookupElement) {
        InsertHandler handler;
        if (lookupElement instanceof PrioritizedLookupElement) {
            lookupElement = ((PrioritizedLookupElement)lookupElement).getDelegate();
        }
        if (lookupElement instanceof LookupElementBuilder && (handler = ((LookupElementBuilder)lookupElement).getInsertHandler()) instanceof JSLookupElementInsertHandler) {
            ((JSLookupElementInsertHandler)handler).setForceQualify(true);
        }
    }

    public static Icon getEmptyIcon() {
        return IconHolder.ourEmptyIcon;
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, JSLookupPriority priority, boolean fromClass, boolean ecma) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(24);
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, fromClass, ecma, null);
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, @NotNull JSLookupPriority priority, boolean fromClass, boolean ecma, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(25);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(26);
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, fromClass, ecma, typeSubstitutor, false);
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, @NotNull JSLookupPriority priority, boolean fromClass, boolean ecma, @Nullable JSTypeSubstitutor typeSubstitutor, boolean insertAsIndexer) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(27);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(28);
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, fromClass, ecma, typeSubstitutor, insertAsIndexer, null);
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, @NotNull JSLookupPriority priority, boolean fromClass, boolean ecma, @Nullable JSTypeSubstitutor typeSubstitutor, boolean insertAsIndexer, @Nullable String lookupString) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(29);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(30);
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, fromClass, ecma, typeSubstitutor, insertAsIndexer, lookupString, null);
    }

    @Nullable
    public static LookupElement createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, @NotNull JSLookupPriority priority, boolean fromClass, boolean ecma, @Nullable JSTypeSubstitutor typeSubstitutor, boolean insertAsIndexer, @Nullable String lookupString, @Nullable Runnable insertHandlerAction) {
        if (name == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(31);
        }
        if (priority == null) {
            JSLookupUtilImpl.$$$reportNull$$$0(32);
        }
        if (JSLookupUtilImpl.willCreateLookupElement(priority)) {
            ProgressManager.checkCanceled();
            LookupElementBuilder builder = LookupElementBuilder.create((Object)(value != null ? value : name), (String)name).withRenderer((LookupElementRenderer)new JSLookupElementRenderer(name, value, priority, ecma, fromClass, typeSubstitutor)).withInsertHandler((InsertHandler)new JSLookupElementInsertHandler(insertAsIndexer, insertHandlerAction));
            if (lookupString == null && StringUtil.isQuotedString((String)name)) {
                lookupString = StringUtil.unquoteString((String)name);
            }
            if (lookupString != null) {
                builder = builder.withLookupString(lookupString);
            }
            JSLookupPriority lookupPriority = priority;
            if (priority == JSLookupPriority.LOCAL_SCOPE_MAX_PRIORITY && insertAsIndexer) {
                lookupPriority = JSLookupPriority.LOCAL_SCOPE_MAX_PRIORITY_EXOTIC;
            }
            if (value instanceof JSImplicitPrototypeElement) {
                lookupPriority = JSLookupPriority.NESTING_LEVEL_REST;
            }
            return JSCompletionUtil.withJSLookupPriority((LookupElement)builder, lookupPriority);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSLookupUtilImpl";
                break;
            }
            case 1: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 8: 
            case 14: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerElement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createMultiparamCompletionItem";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSLookupUtilImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAndTailTexts";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserIcon";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrioritizedLookupElement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupItemForStaticCall";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createImplementAbstractOrInterfaceLookupItem";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAndTailTexts";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageLocationString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "willCreateLookupElement";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createPrioritizedLookupElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toBoldLookupElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createLookupItemForStaticCall";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createImplementAbstractOrInterfaceLookupItem";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "generateMissingMembersForItem";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createPrioritizedLookupItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IconHolder {
        public static final Icon ourEmptyIcon = EmptyIcon.create((Icon)PlatformIcons.CLASS_ICON);
        public static final Icon ourEmptyIconWithVisibility = EmptyIcon.create((int)(PlatformIcons.CLASS_ICON.getIconWidth() * 2), (int)PlatformIcons.CLASS_ICON.getIconHeight());
        public static final Icon ourParamParamIcon = IconHolder.createDoubledIcon(PlatformIcons.PARAMETER_ICON, PlatformIcons.PARAMETER_ICON);

        @NotNull
        public static Icon createDoubledIcon(Icon icon1, Icon icon2) {
            int w = icon1.getIconWidth();
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(icon1, 0, 2 * w / 5, 0);
            icon.setIcon(icon2, 1);
            LayeredIcon layeredIcon = icon;
            if (layeredIcon == null) {
                IconHolder.$$$reportNull$$$0(0);
            }
            return layeredIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupUtilImpl$IconHolder", "createDoubledIcon"));
        }
    }

    public static class BoldCheckingLookupElementPresentation
    extends LookupElementPresentation {
        private LookupElementRenderer<LookupElement> myRenderer = null;

        public void setUseRenderer(LookupElementRenderer<LookupElement> renderer) {
            this.myRenderer = renderer;
        }
    }

    public static interface IBoldnessProvidingLookupElementRenderer {
        public LookupElementRenderer<LookupElement> copyWithBoldness(boolean var1);
    }
}

