package Ocsinventory::Agent::Backend::OS::BSD::Pcictl;
use strict;

sub check {can_run("pcictl")}

sub run {}

sub runpcictl {
	my @devices;
	opendir DEV, "/dev" or die "can't open /dev";
	while (my $file = readdir DEV) {
		if ($file =~ m/^pci[0-9]+$/) {
			foreach (`pcictl $file list`) {
				chop $_;
				push @devices, $_;
			}
		}
	}
	return @devices;
}

1;
