/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.impl.JidCreate;

public class RosterPacketProvider
extends IQProvider<RosterPacket> {
    public static final RosterPacketProvider INSTANCE = new RosterPacketProvider();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public RosterPacket parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        RosterPacket roster = new RosterPacket();
        String version2 = parser2.getAttributeValue("", "ver");
        roster.setVersion(version2);
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String startTag;
                    switch (startTag = parser2.getName()) {
                        case "item": {
                            RosterPacket.Item item = RosterPacketProvider.parseItem(parser2);
                            roster.addRosterItem(item);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    String endTag;
                    switch (endTag = parser2.getName()) {
                        case "query": {
                            if (parser2.getDepth() != initialDepth) break;
                            return roster;
                        }
                    }
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static RosterPacket.Item parseItem(XmlPullParser parser2) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser2, "item");
        int initialDepth = parser2.getDepth();
        String jidString = parser2.getAttributeValue("", "jid");
        String itemName = parser2.getAttributeValue("", "name");
        BareJid jid = JidCreate.bareFrom(jidString);
        RosterPacket.Item item = new RosterPacket.Item(jid, itemName);
        String ask = parser2.getAttributeValue("", "ask");
        item.setSubscriptionPending("subscribe".equals(ask));
        String subscription = parser2.getAttributeValue("", "subscription");
        RosterPacket.ItemType type2 = RosterPacket.ItemType.fromString(subscription);
        item.setItemType(type2);
        boolean approved = ParserUtils.getBooleanAttribute(parser2, "approved", false);
        item.setApproved(approved);
        block10: while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "group": {
                            String groupName = parser2.nextText();
                            if (groupName != null && groupName.trim().length() > 0) {
                                item.addGroupName(groupName);
                                break;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() == initialDepth) break block10;
                }
            }
        }
        ParserUtils.assertAtEndTag(parser2);
        assert (item != null);
        return item;
    }
}

