/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.srtp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.srtp.BaseSrtpCryptoContext;
import org.jitsi.srtp.SrtpContextFactory;
import org.jitsi.srtp.SrtpErrorStatus;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u001f\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH$\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0004\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0018\u001a\u00020\u0019H$\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019J\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jitsi/nlj/srtp/AbstractSrtpTransformer;", "CryptoContextType", "Lorg/jitsi/srtp/BaseSrtpCryptoContext;", "", "contextFactory", "Lorg/jitsi/srtp/SrtpContextFactory;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/srtp/SrtpContextFactory;Lorg/jitsi/utils/logging2/Logger;)V", "getContextFactory", "()Lorg/jitsi/srtp/SrtpContextFactory;", "contexts", "", "", "logger", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "close", "", "deriveContext", "ssrc", "index", "(JJ)Lorg/jitsi/srtp/BaseSrtpCryptoContext;", "getContext", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "(Lorg/jitsi/nlj/PacketInfo;)Lorg/jitsi/srtp/BaseSrtpCryptoContext;", "transform", "Lorg/jitsi/srtp/SrtpErrorStatus;", "context", "(Lorg/jitsi/nlj/PacketInfo;Lorg/jitsi/srtp/BaseSrtpCryptoContext;)Lorg/jitsi/srtp/SrtpErrorStatus;", "jitsi-media-transform"})
public abstract class AbstractSrtpTransformer<CryptoContextType extends BaseSrtpCryptoContext> {
    @NotNull
    private final SrtpContextFactory contextFactory;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<Long, CryptoContextType> contexts;

    public AbstractSrtpTransformer(@NotNull SrtpContextFactory contextFactory, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(contextFactory, "contextFactory");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.contextFactory = contextFactory;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.contexts = new ConcurrentHashMap();
    }

    @NotNull
    protected final SrtpContextFactory getContextFactory() {
        return this.contextFactory;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Map<Long, CryptoContextType> map = this.contexts;
        synchronized (map) {
            boolean bl = false;
            this.contextFactory.close();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final CryptoContextType getContext(long ssrc2, long index) {
        Map<Long, CryptoContextType> map = this.contexts;
        synchronized (map) {
            CryptoContextType CryptoContextType;
            block6: {
                block5: {
                    boolean bl = false;
                    BaseSrtpCryptoContext baseSrtpCryptoContext = (BaseSrtpCryptoContext)this.contexts.get(ssrc2);
                    if (baseSrtpCryptoContext == null) break block5;
                    BaseSrtpCryptoContext it = baseSrtpCryptoContext;
                    boolean bl2 = false;
                    BaseSrtpCryptoContext baseSrtpCryptoContext2 = it;
                    return (CryptoContextType)baseSrtpCryptoContext2;
                }
                if (this.deriveContext(ssrc2, index) != null) break block6;
                AbstractSrtpTransformer $this$getContext_u24lambda_u2d3_u24lambda_u2d2 = this;
                boolean bl = false;
                $this$getContext_u24lambda_u2d3_u24lambda_u2d2.logger.warn("Failed to derive context for " + ssrc2 + " " + index);
                CryptoContextType CryptoContextType2 = null;
                return CryptoContextType2;
            }
            CryptoContextType derivedContext = CryptoContextType;
            Long l = ssrc2;
            this.contexts.put(l, derivedContext);
            CryptoContextType CryptoContextType3 = derivedContext;
            return CryptoContextType3;
        }
    }

    @Nullable
    protected abstract CryptoContextType deriveContext(long var1, long var3);

    @Nullable
    protected abstract CryptoContextType getContext(@NotNull PacketInfo var1);

    @NotNull
    protected abstract SrtpErrorStatus transform(@NotNull PacketInfo var1, @NotNull CryptoContextType var2);

    @NotNull
    public final SrtpErrorStatus transform(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        CryptoContextType CryptoContextType = this.getContext(packetInfo);
        if (CryptoContextType == null) {
            return SrtpErrorStatus.FAIL;
        }
        CryptoContextType context = CryptoContextType;
        return this.transform(packetInfo, context);
    }
}

