/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.util.annotation.Name;

public class HeaderPatternRule
extends PatternRule {
    private String _name;
    private String _value;
    private boolean _add;

    public HeaderPatternRule() {
        this(null, null, null);
    }

    public HeaderPatternRule(@Name(value="pattern") String pattern, @Name(value="name") String name, @Name(value="value") String value2) {
        super(pattern);
        this._handling = false;
        this._terminating = false;
        this._add = false;
        this.setName(name);
        this.setValue(value2);
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setValue(String value2) {
        this._value = value2;
    }

    public void setAdd(boolean add) {
        this._add = add;
    }

    @Override
    public String apply(String target, HttpServletRequest request, HttpServletResponse response2) throws IOException {
        if (this._add) {
            response2.addHeader(this._name, this._value);
        } else {
            response2.setHeader(this._name, this._value);
        }
        return target;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public boolean isAdd() {
        return this._add;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this._name + "," + this._value + "]";
    }
}

