/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jd.gui.spi.TreeNodeFactory;

public abstract class AbstractTreeNodeFactoryProvider
implements TreeNodeFactory {
    protected List<String> externalSelectors;
    protected Pattern externalPathPattern;

    AbstractTreeNodeFactoryProvider() {
        Properties properties = new Properties();
        Class<?> clazz = this.getClass();
        try (InputStream is = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".properties");){
            if (is != null) {
                properties.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.init(properties);
    }

    protected void init(Properties properties) {
        String selectors = properties.getProperty("selectors");
        this.externalSelectors = selectors == null ? null : Arrays.asList(selectors.split(","));
        String pathRegExp = properties.getProperty("pathRegExp");
        this.externalPathPattern = pathRegExp == null ? null : Pattern.compile(pathRegExp);
    }

    protected List<String> getExternalSelectors() {
        return this.externalSelectors;
    }

    protected Pattern getExternalPathPattern() {
        return this.externalPathPattern;
    }

    @Override
    public String[] getSelectors() {
        return this.externalSelectors == null ? null : this.externalSelectors.toArray(new String[this.externalSelectors.size()]);
    }

    @Override
    public Pattern getPathPattern() {
        return this.externalPathPattern;
    }
}

