/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.codecs.dm;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.IvyArtifactNameSerializer;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.CalculatedValueFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.graph.Codec;
import org.gradle.internal.serialize.graph.CombinatorsKt;
import org.gradle.internal.serialize.graph.ReadContext;
import org.gradle.internal.serialize.graph.WriteContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u00020\u0002*\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gradle/internal/serialize/codecs/dm/DefaultResolvableArtifactCodec;", "Lorg/gradle/internal/serialize/graph/Codec;", "Lorg/gradle/api/internal/artifacts/DefaultResolvableArtifact;", "calculatedValueContainerFactory", "Lorg/gradle/internal/model/CalculatedValueContainerFactory;", "(Lorg/gradle/internal/model/CalculatedValueContainerFactory;)V", "componentIdSerializer", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/result/ComponentIdentifierSerializer;", "decode", "Lorg/gradle/internal/serialize/graph/ReadContext;", "(Lorg/gradle/internal/serialize/graph/ReadContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "encode", "", "Lorg/gradle/internal/serialize/graph/WriteContext;", "value", "(Lorg/gradle/internal/serialize/graph/WriteContext;Lorg/gradle/api/internal/artifacts/DefaultResolvableArtifact;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dependency-management-serialization-codecs"})
public final class DefaultResolvableArtifactCodec
implements Codec<DefaultResolvableArtifact> {
    @NotNull
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    @NotNull
    private final ComponentIdentifierSerializer componentIdSerializer;

    public DefaultResolvableArtifactCodec(@NotNull CalculatedValueContainerFactory calculatedValueContainerFactory) {
        Intrinsics.checkNotNullParameter((Object)calculatedValueContainerFactory, (String)"calculatedValueContainerFactory");
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.componentIdSerializer = new ComponentIdentifierSerializer();
    }

    @Nullable
    public Object encode(@NotNull WriteContext $this$encode, @NotNull DefaultResolvableArtifact value, @NotNull Continuation<? super Unit> $completion) {
        Encoder encoder = (Encoder)$this$encode;
        File file = value.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"value.file");
        CombinatorsKt.writeFile((Encoder)encoder, (File)file);
        IvyArtifactNameSerializer.INSTANCE.write((Encoder)$this$encode, value.getArtifactName());
        this.componentIdSerializer.write((Encoder)$this$encode, value.getId().getComponentIdentifier());
        return Unit.INSTANCE;
    }

    @Nullable
    public Object decode(@NotNull ReadContext $this$decode, @NotNull Continuation<? super DefaultResolvableArtifact> $completion) {
        File file = CombinatorsKt.readFile((Decoder)((Decoder)$this$decode));
        IvyArtifactName ivyArtifactName = IvyArtifactNameSerializer.INSTANCE.read((Decoder)$this$decode);
        Intrinsics.checkNotNullExpressionValue((Object)ivyArtifactName, (String)"INSTANCE.read(this)");
        IvyArtifactName artifactName = ivyArtifactName;
        ComponentIdentifier componentIdentifier = this.componentIdSerializer.read((Decoder)$this$decode);
        Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"componentIdSerializer.read(this)");
        ComponentIdentifier componentId = componentIdentifier;
        ComponentFileArtifactIdentifier artifactId = new ComponentFileArtifactIdentifier(componentId, file.getName());
        return new DefaultResolvableArtifact(null, artifactName, (ComponentArtifactIdentifier)artifactId, TaskDependencyContainer.EMPTY, (CalculatedValue)this.calculatedValueContainerFactory.create(Describables.of((Object)artifactId), (Object)file), (CalculatedValueFactory)this.calculatedValueContainerFactory);
    }
}

