/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.LenientConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.ResolvedFilesCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.specs.Spec;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class DefaultResolvedConfiguration
implements ResolvedConfiguration {
    private final VisitedGraphResults graphResults;
    private final ResolutionHost resolutionHost;
    private final VisitedArtifactSet visitedArtifacts;
    private final LenientConfigurationInternal configuration;

    public DefaultResolvedConfiguration(VisitedGraphResults graphResults, ResolutionHost resolutionHost, VisitedArtifactSet visitedArtifacts, LenientConfigurationInternal configuration) {
        this.graphResults = graphResults;
        this.resolutionHost = resolutionHost;
        this.visitedArtifacts = visitedArtifacts;
        this.configuration = configuration;
    }

    public boolean hasError() {
        return this.graphResults.hasAnyFailure();
    }

    public void rethrowFailure() throws ResolveException {
        if (!this.graphResults.hasAnyFailure()) {
            return;
        }
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        this.graphResults.visitFailures(failures::add);
        this.resolutionHost.rethrowFailure("dependencies", failures);
    }

    public LenientConfiguration getLenientConfiguration() {
        return this.configuration;
    }

    public Set<File> getFiles() throws ResolveException {
        ResolvedFilesCollectingVisitor visitor = new ResolvedFilesCollectingVisitor();
        this.visitedArtifacts.select(this.configuration.getImplicitSelectionSpec()).visitArtifacts(visitor, false);
        this.resolutionHost.rethrowFailure("files", visitor.getFailures());
        return visitor.getFiles();
    }

    @Deprecated
    public Set<File> getFiles(Spec<? super Dependency> dependencySpec) throws ResolveException {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(ResolvedConfiguration.class, (String)"getFiles(Spec)").withAdvice("Use an ArtifactView with a componentFilter instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecate_filtered_configuration_file_and_filecollection_methods")).nagUser();
        ResolvedFilesCollectingVisitor visitor = new ResolvedFilesCollectingVisitor();
        this.configuration.select(dependencySpec).visitArtifacts(visitor, false);
        this.resolutionHost.rethrowFailure("files", visitor.getFailures());
        return visitor.getFiles();
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
        this.rethrowFailure();
        return this.configuration.getFirstLevelModuleDependencies();
    }

    @Deprecated
    public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(ResolvedConfiguration.class, (String)"getFirstLevelModuleDependencies(Spec)").withAdvice("Use getFirstLevelModuleDependencies() instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecate_filtered_configuration_file_and_filecollection_methods")).nagUser();
        this.rethrowFailure();
        return (Set)DeprecationLogger.whileDisabled(() -> this.configuration.getFirstLevelModuleDependencies(dependencySpec));
    }

    public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
        ArtifactCollectingVisitor visitor = new ArtifactCollectingVisitor();
        this.visitedArtifacts.select(this.configuration.getImplicitSelectionSpec()).visitArtifacts(visitor, false);
        this.resolutionHost.rethrowFailure("artifacts", visitor.getFailures());
        return visitor.getArtifacts();
    }
}

