/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.OPFChecker;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipFile;

public class XRefChecker {
    public static final int RT_GENERIC = 0;
    public static final int RT_HYPERLINK = 1;
    public static final int RT_IMAGE = 2;
    public static final int RT_OBJECT = 3;
    public static final int RT_STYLESHEET = 4;
    public static final int RT_SVG_PAINT = 16;
    public static final int RT_SVG_CLIP_PATH = 17;
    public static final int RT_SVG_SYMBOL = 18;
    Hashtable resources = new Hashtable();
    HashSet undeclared = new HashSet();
    Vector references = new Vector();
    Report report;
    ZipFile zip;

    public XRefChecker(ZipFile zip, Report report) {
        this.zip = zip;
        this.report = report;
    }

    public void registerResource(String resource, String mimeType) {
        if (this.resources.get(resource) != null) {
            throw new IllegalArgumentException("duplicate resource: " + resource);
        }
        this.resources.put(resource, new Resource(resource, mimeType));
    }

    public void registerAnchor(String resource, int lineNumber, String id, int type) {
        Resource res = (Resource)this.resources.get(resource);
        if (res == null) {
            throw new IllegalArgumentException("unregistered resource: " + resource);
        }
        if (res.anchors.get(id) != null) {
            throw new IllegalArgumentException("duplicate id: " + id);
        }
        res.anchors.put(id, new Anchor(id, lineNumber, type));
    }

    public void registerReference(String srcResource, int srcLineNumber, String refResource, String refFragment, int type) {
        this.references.add(new Reference(srcResource, srcLineNumber, refResource, refFragment, type));
    }

    public void registerReference(String srcResource, int srcLineNumber, String ref, int type) {
        String refFragment;
        String refResource;
        int hash = ref.indexOf("#");
        if (hash >= 0) {
            refResource = ref.substring(0, hash);
            refFragment = ref.substring(hash + 1);
        } else {
            refResource = ref;
            refFragment = null;
        }
        this.registerReference(srcResource, srcLineNumber, refResource, refFragment, type);
    }

    public void checkReferences() {
        Enumeration refs = this.references.elements();
        while (refs.hasMoreElements()) {
            Reference ref = (Reference)refs.nextElement();
            this.checkReference(ref);
        }
    }

    private void checkReference(Reference ref) {
        Resource res = (Resource)this.resources.get(ref.refResource);
        if (res == null) {
            if (this.zip.getEntry(ref.refResource) == null) {
                this.report.error(ref.resource, ref.lineNumber, "'" + ref.refResource + "': referenced resource missing in the package");
            } else if (!this.undeclared.contains(ref.refResource)) {
                this.undeclared.add(ref.refResource);
                this.report.error(ref.resource, ref.lineNumber, "'" + ref.refResource + "': referenced resource exists, but not declared in the OPF file");
            }
            return;
        }
        if (ref.fragment == null) {
            switch (ref.type) {
                case 16: 
                case 17: 
                case 18: {
                    this.report.error(ref.resource, ref.lineNumber, "fragment identifier missing in reference to '" + ref.refResource + "'");
                    break;
                }
                case 1: {
                    if (res.mimeType == null || OPFChecker.isBlessedItemType(res.mimeType) || OPFChecker.isDeprecatedBlessedItemType(res.mimeType)) break;
                    this.report.error(ref.resource, ref.lineNumber, "hyperlink to non-standard resource '" + ref.refResource + "' of type '" + res.mimeType + "'");
                    break;
                }
                case 2: {
                    if (res.mimeType == null || OPFChecker.isBlessedImageType(res.mimeType)) break;
                    this.report.error(ref.resource, ref.lineNumber, "non-standard image resource '" + ref.refResource + "' of type '" + res.mimeType + "'");
                    break;
                }
                case 4: {
                    if (res.mimeType == null || OPFChecker.isBlessedStyleType(res.mimeType) || OPFChecker.isDeprecatedBlessedStyleType(res.mimeType)) break;
                    this.report.error(ref.resource, ref.lineNumber, "non-standard stylesheet resource '" + ref.refResource + "' of type '" + res.mimeType + "'");
                }
            }
        } else {
            switch (ref.type) {
                case 1: {
                    if (res.mimeType == null || OPFChecker.isBlessedItemType(res.mimeType) || OPFChecker.isDeprecatedBlessedItemType(res.mimeType)) break;
                    this.report.error(ref.resource, ref.lineNumber, "hyperlink to non-standard resource '" + ref.refResource + "' of type '" + res.mimeType + "'");
                    break;
                }
                case 2: {
                    this.report.error(ref.resource, ref.lineNumber, "fragment identifier used for image resource '" + ref.refResource + "'");
                    break;
                }
                case 4: {
                    this.report.error(ref.resource, ref.lineNumber, "fragment identifier used for stylesheet resource '" + ref.refResource + "'");
                }
            }
            Anchor anchor = (Anchor)res.anchors.get(ref.fragment);
            if (anchor == null) {
                this.report.error(ref.resource, ref.lineNumber, "'" + ref.fragment + "': fragment identifier is not defined in '" + ref.refResource + "'");
                return;
            }
            switch (ref.type) {
                case 16: 
                case 17: {
                    if (anchor.type == ref.type) break;
                    this.report.error(ref.resource, ref.lineNumber, "fragment identifier '" + ref.fragment + "' defines incompatible resource type in '" + ref.refResource + "'");
                    break;
                }
                case 1: 
                case 18: {
                    if (anchor.type == ref.type || anchor.type == 0) break;
                    this.report.error(ref.resource, ref.lineNumber, "fragment identifier '" + ref.fragment + "' defines incompatible resource type in '" + ref.refResource + "'");
                }
            }
        }
    }

    private class Resource {
        String resource;
        String mimeType;
        Hashtable anchors;

        Resource(String resource, String type) {
            this.mimeType = type;
            this.resource = resource;
            this.anchors = new Hashtable();
        }
    }

    private class Anchor {
        String id;
        int lineNumber;
        int type;

        public Anchor(String id, int lineNumber, int type) {
            this.id = id;
            this.lineNumber = lineNumber;
            this.type = type;
        }
    }

    private class Reference {
        String resource;
        int lineNumber;
        String refResource;
        String fragment;
        int type;

        public Reference(String srcResource, int srcLineNumber, String refResource, String fragment, int type) {
            this.fragment = fragment;
            this.lineNumber = srcLineNumber;
            this.refResource = refResource;
            this.resource = srcResource;
            this.type = type;
        }
    }
}

