/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.matrix;

import net.loomchild.maligna.matrix.BandMatrixIterator;
import net.loomchild.maligna.matrix.Matrix;
import net.loomchild.maligna.matrix.MatrixIterator;
import net.loomchild.maligna.matrix.PositionOutsideBandException;

public class BandMatrix<T>
implements Matrix<T> {
    private Object[][] dataArray;
    private int width;
    private int height;
    private int bandWidth;
    private int bandRadius;
    float widthHeightRatio;

    public BandMatrix(int width, int height, int bandRadius) {
        assert (bandRadius >= 1);
        this.width = width;
        this.height = height;
        this.bandRadius = bandRadius;
        this.bandWidth = bandRadius * 2 + 1;
        this.dataArray = new Object[this.bandWidth][height];
        this.widthHeightRatio = (float)width / (float)height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getSize() {
        return this.bandWidth * this.height - (int)((float)(this.bandRadius * this.bandRadius) * this.widthHeightRatio);
    }

    @Override
    public T get(int x, int y) {
        assert (x >= 0 && x < this.width);
        assert (y >= 0 && y < this.height);
        int actualX = this.getActualX(x, y);
        if (actualX >= 0 && actualX < this.bandWidth) {
            return (T)this.dataArray[actualX][y];
        }
        return null;
    }

    @Override
    public void set(int x, int y, T data) {
        assert (x >= 0 && x < this.width);
        assert (y >= 0 && y < this.height);
        int actualX = this.getActualX(x, y);
        if (actualX < 0 || actualX >= this.bandWidth) {
            throw new PositionOutsideBandException(x, y, this.width, this.height, this.bandWidth);
        }
        this.dataArray[actualX][y] = data;
    }

    int getBandRadius() {
        return this.bandRadius;
    }

    int getDiagonalX(int y) {
        return (int)((float)y * this.widthHeightRatio);
    }

    private int getActualX(int x, int y) {
        return x - this.getDiagonalX(y) + this.bandRadius;
    }

    @Override
    public MatrixIterator<T> getIterator() {
        return new BandMatrixIterator(this);
    }
}

