/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.tokenizer;

import java.io.IOException;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.omegat.tokenizer.BaseTokenizer;
import org.omegat.tokenizer.Tokenizer;

@Tokenizer(languages={"de"}, isDefault=true)
public class LuceneGermanTokenizer
extends BaseTokenizer {
    @Override
    protected TokenStream getTokenStream(String strOrig, boolean stemsAllowed, boolean stopWordsAllowed) throws IOException {
        if (stemsAllowed) {
            CharArraySet stopWords = stopWordsAllowed ? GermanAnalyzer.getDefaultStopSet() : CharArraySet.EMPTY_SET;
            return new Lucene30GermanAnalyzer(stopWords).tokenStream("", new StringReader(strOrig));
        }
        return this.getStandardTokenStream(strOrig);
    }

    private static class Lucene30GermanAnalyzer
    extends Analyzer {
        private final CharArraySet stopWords;

        Lucene30GermanAnalyzer(CharArraySet stopWords) {
            this.stopWords = stopWords;
        }

        protected Analyzer.TokenStreamComponents createComponents(String arg0) {
            StandardTokenizer source = new StandardTokenizer();
            StandardFilter result = new StandardFilter((TokenStream)source);
            result = new LowerCaseFilter((TokenStream)result);
            result = new StopFilter((TokenStream)result, this.stopWords);
            result = new SetKeywordMarkerFilter((TokenStream)result, CharArraySet.EMPTY_SET);
            result = new GermanStemFilter((TokenStream)result);
            return new Analyzer.TokenStreamComponents((org.apache.lucene.analysis.Tokenizer)source, (TokenStream)result);
        }
    }
}

