/*
 * Decompiled with CFR 0.152.
 */
package tokyo.northside.stardict;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.trie4j.MapTrie;
import org.trie4j.doublearray.MapDoubleArray;

public class DictionaryData<T> {
    private final MapDoubleArray<Object> data;

    DictionaryData(MapTrie<Object> mapTrie) {
        this.data = new MapDoubleArray(mapTrie);
    }

    public List<Map.Entry<String, T>> lookUp(String word) {
        ArrayList<Map.Entry<String, T>> result = new ArrayList<Map.Entry<String, T>>();
        this.get(word, this.data.get(word), result);
        return result;
    }

    public List<Map.Entry<String, T>> lookUpPredictive(String word) {
        ArrayList<Map.Entry<String, T>> result = new ArrayList<Map.Entry<String, T>>();
        this.data.predictiveSearchEntries(word).forEach(e -> this.get((String)e.getKey(), e.getValue(), result));
        return result;
    }

    private <U> void get(U key, Object value, Collection<Map.Entry<U, T>> into) {
        if (value == null) {
            return;
        }
        if (value instanceof Object[]) {
            for (Object o : (Object[])value) {
                if (o == null) continue;
                into.add(new AbstractMap.SimpleImmutableEntry<U, Object>(key, o));
            }
        } else {
            into.add(new AbstractMap.SimpleImmutableEntry<U, Object>(key, value));
        }
    }

    public int size() {
        return this.data.size();
    }
}

