/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class FSTransactionItemIndex
implements Closeable {
    private static final String FILENAME = "itemidx";
    private final RandomAccessFile file;

    public static FSTransactionItemIndex open(FSFS fsfs, String txnId) throws SVNException {
        try {
            return new FSTransactionItemIndex(new RandomAccessFile(FSTransactionItemIndex.getIndexPath(fsfs, txnId), "rw"));
        }
        catch (FileNotFoundException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            return null;
        }
    }

    public static File getIndexPath(FSFS fsfs, String txnId) {
        File transactionDir = fsfs.getTransactionDir(txnId);
        return SVNFileUtil.createFilePath(transactionDir, FILENAME);
    }

    private FSTransactionItemIndex(RandomAccessFile file) {
        this.file = file;
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().log(SVNLogType.FSFS, e, Level.INFO);
        }
    }

    public long allocateItemIndex(long offset) throws SVNException {
        byte[] numberBytes = new byte[21];
        long itemIndex = 0L;
        try {
            int bytesRead = this.file.read(numberBytes);
            if (bytesRead < 0) {
                itemIndex = 3L;
            } else {
                int position = FSTransactionItemIndex.arrayIndexOf(numberBytes, (byte)0);
                String numberString = position >= 0 ? new String(numberBytes, 0, position) : new String(numberBytes);
                try {
                    itemIndex = Long.parseLong(numberString);
                }
                catch (NumberFormatException e) {
                    itemIndex = 3L;
                }
            }
        }
        catch (EOFException e) {
            itemIndex = 3L;
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        try {
            this.file.seek(0L);
            String incrementedItemIndexString = String.valueOf(itemIndex + 1L);
            byte[] incrementedItemIndexBytes = incrementedItemIndexString.getBytes();
            this.file.write(incrementedItemIndexBytes);
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        return itemIndex;
    }

    private static int arrayIndexOf(byte[] array, byte value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }
}

