/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.chunking;

import edu.washington.cs.knowitall.logic.Expression;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.chunking.ChunkTaggedToken;

final class TokenPredicate
extends Expression.Arg.Pred<ChunkTaggedToken> {
    private final boolean caseSensitive;

    TokenPredicate(String description, boolean caseSensitive) {
        super(description);
        this.caseSensitive = caseSensitive;
    }

    public boolean apply(ChunkTaggedToken analyzedToken) {
        String exprValue;
        String exprType;
        String[] parts = this.getDescription().split("=");
        if (parts.length == 1) {
            exprType = "string";
            exprValue = parts[0];
        } else if (parts.length == 2) {
            exprType = parts[0];
            exprValue = parts[1];
        } else {
            throw new RuntimeException("Could not parse expression: " + this.getDescription());
        }
        if (exprValue.startsWith("'") && exprValue.endsWith("'")) {
            exprValue = exprValue.substring(1, exprValue.length() - 1);
        }
        switch (exprType) {
            case "string": {
                if (this.caseSensitive) {
                    return analyzedToken.getToken().equals(exprValue);
                }
                return analyzedToken.getToken().equalsIgnoreCase(exprValue);
            }
            case "regex": {
                Pattern p1 = this.caseSensitive ? Pattern.compile(exprValue) : Pattern.compile(exprValue, 2);
                return p1.matcher(analyzedToken.getToken()).matches();
            }
            case "regexCS": {
                Pattern p2 = Pattern.compile(exprValue);
                return p2.matcher(analyzedToken.getToken()).matches();
            }
            case "chunk": {
                Pattern chunkPattern = Pattern.compile(exprValue);
                for (ChunkTag chunkTag : analyzedToken.getChunkTags()) {
                    if (!chunkPattern.matcher(chunkTag.getChunkTag()).matches()) continue;
                    return true;
                }
                return false;
            }
            case "pos": {
                AnalyzedTokenReadings readings = analyzedToken.getReadings();
                if (readings != null) {
                    for (AnalyzedToken token : readings) {
                        if (token.getPOSTag() == null || !token.getPOSTag().contains(exprValue)) continue;
                        return true;
                    }
                }
                return false;
            }
            case "posre": 
            case "posregex": {
                Pattern posPattern = Pattern.compile(exprValue);
                AnalyzedTokenReadings readings2 = analyzedToken.getReadings();
                if (readings2 != null) {
                    for (AnalyzedToken token : readings2) {
                        if (token.getPOSTag() == null || !posPattern.matcher(token.getPOSTag()).matches()) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        throw new RuntimeException("Expression type not supported: '" + exprType + "'");
    }
}

