/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.bv;

import org.trie4j.bv.BitVector;

public class BitVectorUtil {
    public static void divide01(BitVector org, BitVector vec0, BitVector vec1) {
        if (org.size() == 0) {
            return;
        }
        if (org.size() == 1) {
            if (!org.isZero(0)) {
                throw new IllegalArgumentException("invalid bv for trie");
            }
            vec0.append1();
            return;
        }
        boolean zeroCounting = org.isZero(0);
        int n = org.size();
        for (int i = 1; i < n; ++i) {
            if (zeroCounting) {
                if (org.isZero(i)) {
                    vec0.append1();
                    continue;
                }
                vec0.append0();
                zeroCounting = false;
                continue;
            }
            if (org.isZero(i)) {
                vec1.append0();
                zeroCounting = true;
                continue;
            }
            vec1.append1();
        }
    }

    public static void appendBitStrings(BitVector bv, String[] bs) {
        for (String s : bs) {
            if (s.length() != 8) {
                throw new RuntimeException("The length of bit string must be 8  while " + s.length());
            }
            for (char c : s.toCharArray()) {
                if (c == '0') {
                    bv.append0();
                    continue;
                }
                if (c == '1') {
                    bv.append1();
                    continue;
                }
                throw new RuntimeException("invalid char '" + c + "' for bit string.");
            }
        }
    }
}

