<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Storagetransfer;

class ObjectConditions extends \Google\Collection
{
  protected $collection_key = 'includePrefixes';
  public $excludePrefixes;
  public $includePrefixes;
  public $lastModifiedBefore;
  public $lastModifiedSince;
  public $maxTimeElapsedSinceLastModification;
  public $minTimeElapsedSinceLastModification;

  public function setExcludePrefixes($excludePrefixes)
  {
    $this->excludePrefixes = $excludePrefixes;
  }
  public function getExcludePrefixes()
  {
    return $this->excludePrefixes;
  }
  public function setIncludePrefixes($includePrefixes)
  {
    $this->includePrefixes = $includePrefixes;
  }
  public function getIncludePrefixes()
  {
    return $this->includePrefixes;
  }
  public function setLastModifiedBefore($lastModifiedBefore)
  {
    $this->lastModifiedBefore = $lastModifiedBefore;
  }
  public function getLastModifiedBefore()
  {
    return $this->lastModifiedBefore;
  }
  public function setLastModifiedSince($lastModifiedSince)
  {
    $this->lastModifiedSince = $lastModifiedSince;
  }
  public function getLastModifiedSince()
  {
    return $this->lastModifiedSince;
  }
  public function setMaxTimeElapsedSinceLastModification($maxTimeElapsedSinceLastModification)
  {
    $this->maxTimeElapsedSinceLastModification = $maxTimeElapsedSinceLastModification;
  }
  public function getMaxTimeElapsedSinceLastModification()
  {
    return $this->maxTimeElapsedSinceLastModification;
  }
  public function setMinTimeElapsedSinceLastModification($minTimeElapsedSinceLastModification)
  {
    $this->minTimeElapsedSinceLastModification = $minTimeElapsedSinceLastModification;
  }
  public function getMinTimeElapsedSinceLastModification()
  {
    return $this->minTimeElapsedSinceLastModification;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ObjectConditions::class, 'Google_Service_Storagetransfer_ObjectConditions');
