/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.run;

import br.arca.morcego.Config;
import br.arca.morcego.structure.Graph;
import br.arca.morcego.structure.Node;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class Animator
implements Runnable {
    private Graph graph;
    private Vector visible;

    public Animator(Graph g) {
        this.graph = g;
        this.visible = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate(Vector visible) {
        Animator animator = this;
        synchronized (animator) {
            this.visible = visible;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setPriority(1);
        while (true) {
            block9: {
                try {
                    if (!this.visible.isEmpty()) break block9;
                    Animator animator = this;
                    synchronized (animator) {
                        this.wait();
                    }
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
            this.graph.calculateDistances();
            this.graph.hideFarNodes();
            Collections.sort(this.visible, new AnimationStrategy());
            while (!this.visible.isEmpty()) {
                Node node = (Node)this.visible.remove(0);
                this.graph.showNode(node);
                try {
                    Thread.sleep(Config.getInteger("morcego.feedAnimationInterval"));
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            this.visible = new Vector();
        }
    }

    private final class AnimationStrategy
    implements Comparator {
        private AnimationStrategy() {
        }

        public int compare(Object o1, Object o2) {
            Node n1 = (Node)o1;
            Node n2 = (Node)o2;
            if (n1.getCenterDistance() < n2.getCenterDistance()) {
                return -1;
            }
            if (n1.getCenterDistance() > n2.getCenterDistance()) {
                return 1;
            }
            return 0;
        }
    }
}

