/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.physics;

import br.arca.morcego.physics.Vector3D;
import java.awt.Point;

public class Matrix2x3 {
    private Vector3D x;
    private Vector3D y;

    public Matrix2x3() {
        this.x = new Vector3D();
        this.y = new Vector3D();
    }

    public Matrix2x3(Vector3D x, Vector3D y) {
        this.x = new Vector3D(x.x, x.y, x.z);
        this.y = new Vector3D(y.x, y.y, y.z);
    }

    public Matrix2x3(float xx, float xy, float xz, float yx, float yy, float yz) {
        this.x = new Vector3D(xx, xy, xz);
        this.y = new Vector3D(yx, yy, yz);
    }

    public Matrix2x3 multiplyByScalar(float n) {
        Vector3D X = this.x.multiplyByScalar(n);
        Vector3D Y = this.y.multiplyByScalar(n);
        return new Matrix2x3(X, Y);
    }

    public Point multiplyByVector(Vector3D vector) {
        return new Point(new Float(this.x.scalarProduct(vector)).intValue(), new Float(this.y.scalarProduct(vector)).intValue());
    }

    public String toString() {
        return new String("[(" + this.x.x + "," + this.x.y + "," + this.x.z + ")\n" + "(" + this.y.x + "," + this.y.y + "," + this.y.z + ")]");
    }
}

